package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobSourceBuilder extends CronJobSourceFluentImpl<CronJobSourceBuilder> implements VisitableBuilder<CronJobSource,CronJobSourceBuilder>{

    CronJobSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobSourceBuilder(){
            this(true);
    }
    public CronJobSourceBuilder(Boolean validationEnabled){
            this(new CronJobSource(), validationEnabled);
    }
    public CronJobSourceBuilder(CronJobSourceFluent<?> fluent){
            this(fluent, true);
    }
    public CronJobSourceBuilder(CronJobSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CronJobSource(), validationEnabled);
    }
    public CronJobSourceBuilder(CronJobSourceFluent<?> fluent,CronJobSource instance){
            this(fluent, instance, true);
    }
    public CronJobSourceBuilder(CronJobSourceFluent<?> fluent,CronJobSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withDeprecated(instance.getDeprecated()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public CronJobSourceBuilder(CronJobSource instance){
            this(instance,true);
    }
    public CronJobSourceBuilder(CronJobSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withDeprecated(instance.getDeprecated()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public CronJobSource build(){
            CronJobSource buildable = new CronJobSource(fluent.getApiVersion(),fluent.getDeprecated(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CronJobSourceBuilder that = (CronJobSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
