package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigurationStatusBuilder extends ConfigurationStatusFluentImpl<ConfigurationStatusBuilder> implements VisitableBuilder<ConfigurationStatus,ConfigurationStatusBuilder>{

    ConfigurationStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigurationStatusBuilder(){
            this(true);
    }
    public ConfigurationStatusBuilder(Boolean validationEnabled){
            this(new ConfigurationStatus(), validationEnabled);
    }
    public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConfigurationStatus(), validationEnabled);
    }
    public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,ConfigurationStatus instance){
            this(fluent, instance, true);
    }
    public ConfigurationStatusBuilder(ConfigurationStatusFluent<?> fluent,ConfigurationStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
            fluent.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigurationStatusBuilder(ConfigurationStatus instance){
            this(instance,true);
    }
    public ConfigurationStatusBuilder(ConfigurationStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
            this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConfigurationStatus build(){
            ConfigurationStatus buildable = new ConfigurationStatus(fluent.getConditions(),fluent.getLatestCreatedRevisionName(),fluent.getLatestReadyRevisionName(),fluent.getObservedGeneration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigurationStatusBuilder that = (ConfigurationStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
