package io.fabric8.knative.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConditionFluentImpl<A extends ConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConditionFluent<A>{

    private VolatileTimeBuilder lastTransitionTime;
    private String message;
    private String reason;
    private String severity;
    private String status;
    private String type;

    public ConditionFluentImpl(){
    }
    public ConditionFluentImpl(Condition instance){
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withSeverity(instance.getSeverity()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildLastTransitionTime instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public VolatileTime getLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public VolatileTime buildLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public A withLastTransitionTime(VolatileTime lastTransitionTime){
            _visitables.get("lastTransitionTime").remove(this.lastTransitionTime);
            if (lastTransitionTime!=null){ this.lastTransitionTime= new VolatileTimeBuilder(lastTransitionTime); _visitables.get("lastTransitionTime").add(this.lastTransitionTime);} return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime != null;
    }

    public A withNewLastTransitionTime(String inner){
            return (A)withLastTransitionTime(new VolatileTime(inner));
    }

    public ConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime(){
            return new LastTransitionTimeNestedImpl();
    }

    public ConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(VolatileTime item){
            return new LastTransitionTimeNestedImpl(item);
    }

    public ConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime());
    }

    public ConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): new VolatileTimeBuilder().build());
    }

    public ConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(VolatileTime item){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): item);
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public A withNewReason(String arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1){
            return (A)withReason(new String(arg1));
    }

    public String getSeverity(){
            return this.severity;
    }

    public A withSeverity(String severity){
            this.severity=severity; return (A) this;
    }

    public Boolean hasSeverity(){
            return this.severity != null;
    }

    public A withNewSeverity(String arg1){
            return (A)withSeverity(new String(arg1));
    }

    public A withNewSeverity(StringBuilder arg1){
            return (A)withSeverity(new String(arg1));
    }

    public A withNewSeverity(StringBuffer arg1){
            return (A)withSeverity(new String(arg1));
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public A withNewStatus(String arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1){
            return (A)withStatus(new String(arg1));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConditionFluentImpl that = (ConditionFluentImpl) o;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (severity != null ? !severity.equals(that.severity) :that.severity != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class LastTransitionTimeNestedImpl<N> extends VolatileTimeFluentImpl<ConditionFluent.LastTransitionTimeNested<N>> implements ConditionFluent.LastTransitionTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final VolatileTimeBuilder builder;
    
            LastTransitionTimeNestedImpl(VolatileTime item){
                    this.builder = new VolatileTimeBuilder(this, item);
            }
            LastTransitionTimeNestedImpl(){
                    this.builder = new VolatileTimeBuilder(this);
            }
    
    public N and(){
            return (N) ConditionFluentImpl.this.withLastTransitionTime(builder.build());
    }
    public N endLastTransitionTime(){
            return and();
    }

}


}
