package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ChannelableListFluent<A extends ChannelableListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Channelable item);
    public A setToItems(int index,Channelable item);
    public A addToItems(Channelable... items);
    public A addAllToItems(Collection<Channelable> items);
    public A removeFromItems(Channelable... items);
    public A removeAllFromItems(Collection<Channelable> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ChannelableBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<Channelable> getItems();
    public List<Channelable> buildItems();
    public Channelable buildItem(int index);
    public Channelable buildFirstItem();
    public Channelable buildLastItem();
    public Channelable buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ChannelableBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ChannelableBuilder> predicate);
    public A withItems(List<Channelable> items);
    public A withItems(Channelable... items);
    public Boolean hasItems();
    public ChannelableListFluent.ItemsNested<A> addNewItem();
    public ChannelableListFluent.ItemsNested<A> addNewItemLike(Channelable item);
    public ChannelableListFluent.ItemsNested<A> setNewItemLike(int index,Channelable item);
    public ChannelableListFluent.ItemsNested<A> editItem(int index);
    public ChannelableListFluent.ItemsNested<A> editFirstItem();
    public ChannelableListFluent.ItemsNested<A> editLastItem();
    public ChannelableListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ChannelableBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ChannelableFluent<ChannelableListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
