package io.fabric8.knative.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelableBuilder extends io.fabric8.knative.duck.v1beta1.ChannelableFluentImpl<io.fabric8.knative.duck.v1beta1.ChannelableBuilder> implements VisitableBuilder<io.fabric8.knative.duck.v1beta1.Channelable,io.fabric8.knative.duck.v1beta1.ChannelableBuilder>{

    io.fabric8.knative.duck.v1beta1.ChannelableFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelableBuilder(){
            this(true);
    }
    public ChannelableBuilder(Boolean validationEnabled){
            this(new Channelable(), validationEnabled);
    }
    public ChannelableBuilder(io.fabric8.knative.duck.v1beta1.ChannelableFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelableBuilder(io.fabric8.knative.duck.v1beta1.ChannelableFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Channelable(), validationEnabled);
    }
    public ChannelableBuilder(io.fabric8.knative.duck.v1beta1.ChannelableFluent<?> fluent,io.fabric8.knative.duck.v1beta1.Channelable instance){
            this(fluent, instance, true);
    }
    public ChannelableBuilder(io.fabric8.knative.duck.v1beta1.ChannelableFluent<?> fluent,io.fabric8.knative.duck.v1beta1.Channelable instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelableBuilder(io.fabric8.knative.duck.v1beta1.Channelable instance){
            this(instance,true);
    }
    public ChannelableBuilder(io.fabric8.knative.duck.v1beta1.Channelable instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.duck.v1beta1.Channelable build(){
            Channelable buildable = new Channelable(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelableBuilder that = (ChannelableBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
