package io.fabric8.knative.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableListBuilder extends SubscribableListFluentImpl<SubscribableListBuilder> implements VisitableBuilder<SubscribableList,SubscribableListBuilder>{

    SubscribableListFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableListBuilder(){
            this(true);
    }
    public SubscribableListBuilder(Boolean validationEnabled){
            this(new SubscribableList(), validationEnabled);
    }
    public SubscribableListBuilder(SubscribableListFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableListBuilder(SubscribableListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableList(), validationEnabled);
    }
    public SubscribableListBuilder(SubscribableListFluent<?> fluent,SubscribableList instance){
            this(fluent, instance, true);
    }
    public SubscribableListBuilder(SubscribableListFluent<?> fluent,SubscribableList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableListBuilder(SubscribableList instance){
            this(instance,true);
    }
    public SubscribableListBuilder(SubscribableList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscribableList build(){
            SubscribableList buildable = new SubscribableList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableListBuilder that = (SubscribableListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
