package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelListBuilder extends ParallelListFluentImpl<ParallelListBuilder> implements VisitableBuilder<ParallelList,ParallelListBuilder>{

    ParallelListFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelListBuilder(){
            this(true);
    }
    public ParallelListBuilder(Boolean validationEnabled){
            this(new ParallelList(), validationEnabled);
    }
    public ParallelListBuilder(ParallelListFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelListBuilder(ParallelListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelList(), validationEnabled);
    }
    public ParallelListBuilder(ParallelListFluent<?> fluent,ParallelList instance){
            this(fluent, instance, true);
    }
    public ParallelListBuilder(ParallelListFluent<?> fluent,ParallelList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelListBuilder(ParallelList instance){
            this(instance,true);
    }
    public ParallelListBuilder(ParallelList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelList build(){
            ParallelList buildable = new ParallelList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelListBuilder that = (ParallelListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
