package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelSubscriptionStatusBuilder extends ParallelSubscriptionStatusFluentImpl<ParallelSubscriptionStatusBuilder> implements VisitableBuilder<ParallelSubscriptionStatus,ParallelSubscriptionStatusBuilder>{

    ParallelSubscriptionStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelSubscriptionStatusBuilder(){
            this(true);
    }
    public ParallelSubscriptionStatusBuilder(Boolean validationEnabled){
            this(new ParallelSubscriptionStatus(), validationEnabled);
    }
    public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelSubscriptionStatus(), validationEnabled);
    }
    public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent,ParallelSubscriptionStatus instance){
            this(fluent, instance, true);
    }
    public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatusFluent<?> fluent,ParallelSubscriptionStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReady(instance.getReady()); 
            fluent.withSubscription(instance.getSubscription()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatus instance){
            this(instance,true);
    }
    public ParallelSubscriptionStatusBuilder(ParallelSubscriptionStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReady(instance.getReady()); 
            this.withSubscription(instance.getSubscription()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelSubscriptionStatus build(){
            ParallelSubscriptionStatus buildable = new ParallelSubscriptionStatus(fluent.getReady(),fluent.getSubscription());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelSubscriptionStatusBuilder that = (ParallelSubscriptionStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
