package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ApiServerResourceBuilder extends ApiServerResourceFluentImpl<ApiServerResourceBuilder> implements VisitableBuilder<ApiServerResource,ApiServerResourceBuilder>{

    ApiServerResourceFluent<?> fluent;
    Boolean validationEnabled;

    public ApiServerResourceBuilder(){
            this(true);
    }
    public ApiServerResourceBuilder(Boolean validationEnabled){
            this(new ApiServerResource(), validationEnabled);
    }
    public ApiServerResourceBuilder(ApiServerResourceFluent<?> fluent){
            this(fluent, true);
    }
    public ApiServerResourceBuilder(ApiServerResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiServerResource(), validationEnabled);
    }
    public ApiServerResourceBuilder(ApiServerResourceFluent<?> fluent,ApiServerResource instance){
            this(fluent, instance, true);
    }
    public ApiServerResourceBuilder(ApiServerResourceFluent<?> fluent,ApiServerResource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withController(instance.getController()); 
            fluent.withControllerSelector(instance.getControllerSelector()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLabelSelector(instance.getLabelSelector()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiServerResourceBuilder(ApiServerResource instance){
            this(instance,true);
    }
    public ApiServerResourceBuilder(ApiServerResource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withController(instance.getController()); 
            this.withControllerSelector(instance.getControllerSelector()); 
            this.withKind(instance.getKind()); 
            this.withLabelSelector(instance.getLabelSelector()); 
            this.validationEnabled = validationEnabled; 
    }

    public ApiServerResource build(){
            ApiServerResource buildable = new ApiServerResource(fluent.getApiVersion(),fluent.isController(),fluent.getControllerSelector(),fluent.getKind(),fluent.getLabelSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiServerResourceBuilder that = (ApiServerResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
