package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.model.OwnerReference;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ApiServerResourceFluent<A extends ApiServerResourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public Boolean isController();
    public A withController(Boolean controller);
    public Boolean hasController();
    public A withNewController(String arg1);
    public A withNewController(boolean arg1);
    public OwnerReference getControllerSelector();
    public A withControllerSelector(OwnerReference controllerSelector);
    public Boolean hasControllerSelector();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public LabelSelector getLabelSelector();
    public A withLabelSelector(LabelSelector labelSelector);
    public Boolean hasLabelSelector();



}
