
package io.fabric8.knative.legacysources.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.duck.v1beta1.Destination;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "mode",
    "resources",
    "serviceAccountName",
    "sink"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(Volume.class),
    @BuildableReference(Container.class)
})
public class ApiServerSourceSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("mode")
    private String mode;
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    private List<ApiServerResource> resources = new ArrayList<ApiServerResource>();
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccountName")
    private String serviceAccountName;
    /**
     * 
     * 
     */
    @JsonProperty("sink")
    private Destination sink;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApiServerSourceSpec() {
    }

    /**
     * 
     * @param mode
     * @param serviceAccountName
     * @param sink
     * @param resources
     */
    public ApiServerSourceSpec(String mode, List<ApiServerResource> resources, String serviceAccountName, Destination sink) {
        this.mode = mode;
        this.resources = resources;
        this.serviceAccountName = serviceAccountName;
        this.sink = sink;
    }

    /**
     * 
     * 
     * @return
     *     The mode
     */
    @JsonProperty("mode")
    public String getMode() {
        return mode;
    }

    /**
     * 
     * 
     * @param mode
     *     The mode
     */
    @JsonProperty("mode")
    public void setMode(String mode) {
        this.mode = mode;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public List<ApiServerResource> getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(List<ApiServerResource> resources) {
        this.resources = resources;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public String getServiceAccountName() {
        return serviceAccountName;
    }

    /**
     * 
     * 
     * @param serviceAccountName
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    /**
     * 
     * 
     * @return
     *     The sink
     */
    @JsonProperty("sink")
    public Destination getSink() {
        return sink;
    }

    /**
     * 
     * 
     * @param sink
     *     The sink
     */
    @JsonProperty("sink")
    public void setSink(Destination sink) {
        this.sink = sink;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
