package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.knative.duck.v1beta1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.knative.duck.v1beta1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.knative.duck.v1beta1.DestinationFluentImpl;
import java.lang.Boolean;

public class ContainerSourceSpecFluentImpl<A extends ContainerSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerSourceSpecFluent<A>{

    private List<String> args;
    private List<EnvVar> env;
    private String image;
    private String serviceAccountName;
    private io.fabric8.knative.duck.v1beta1.DestinationBuilder sink;
    private PodTemplateSpec template;

    public ContainerSourceSpecFluentImpl(){
    }
    public ContainerSourceSpecFluentImpl(ContainerSourceSpec instance){
            this.withArgs(instance.getArgs()); 
            this.withEnv(instance.getEnv()); 
            this.withImage(instance.getImage()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withSink(instance.getSink()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public A addToArgs(int index,String item){
            if (this.args == null) {this.args = new ArrayList<String>();}
            this.args.add(index, item);
            return (A)this;
    }

    public A setToArgs(int index,String item){
            if (this.args == null) {this.args = new ArrayList<String>();}
            this.args.set(index, item); return (A)this;
    }

    public A addToArgs(String... items){
            if (this.args == null) {this.args = new ArrayList<String>();}
            for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A addAllToArgs(Collection<String> items){
            if (this.args == null) {this.args = new ArrayList<String>();}
            for (String item : items) {this.args.add(item);} return (A)this;
    }

    public A removeFromArgs(String... items){
            for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public A removeAllFromArgs(Collection<String> items){
            for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
    }

    public List<String> getArgs(){
            return this.args;
    }

    public String getArg(int index){
            return this.args.get(index);
    }

    public String getFirstArg(){
            return this.args.get(0);
    }

    public String getLastArg(){
            return this.args.get(args.size() - 1);
    }

    public String getMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: args) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: args) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withArgs(List<String> args){
            if (this.args != null) { _visitables.get("args").removeAll(this.args);}
            if (args != null) {this.args = new ArrayList<String>(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
    }

    public A withArgs(String... args){
            if (this.args != null) {this.args.clear();}
            if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
    }

    public Boolean hasArgs(){
            return args != null && !args.isEmpty();
    }

    public A addNewArg(String arg1){
            return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(StringBuilder arg1){
            return (A)addToArgs(new String(arg1));
    }

    public A addNewArg(StringBuffer arg1){
            return (A)addToArgs(new String(arg1));
    }

    public A addToEnv(int index,EnvVar item){
            if (this.env == null) {this.env = new ArrayList<EnvVar>();}
            this.env.add(index, item);
            return (A)this;
    }

    public A setToEnv(int index,EnvVar item){
            if (this.env == null) {this.env = new ArrayList<EnvVar>();}
            this.env.set(index, item); return (A)this;
    }

    public A addToEnv(EnvVar... items){
            if (this.env == null) {this.env = new ArrayList<EnvVar>();}
            for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A addAllToEnv(Collection<EnvVar> items){
            if (this.env == null) {this.env = new ArrayList<EnvVar>();}
            for (EnvVar item : items) {this.env.add(item);} return (A)this;
    }

    public A removeFromEnv(EnvVar... items){
            for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public A removeAllFromEnv(Collection<EnvVar> items){
            for (EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
    }

    public List<EnvVar> getEnv(){
            return this.env;
    }

    public EnvVar getEnv(int index){
            return this.env.get(index);
    }

    public EnvVar getFirstEnv(){
            return this.env.get(0);
    }

    public EnvVar getLastEnv(){
            return this.env.get(env.size() - 1);
    }

    public EnvVar getMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate){
            for (EnvVar item: env) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate){
            for (EnvVar item: env) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEnv(List<EnvVar> env){
            if (this.env != null) { _visitables.get("env").removeAll(this.env);}
            if (env != null) {this.env = new ArrayList<EnvVar>(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(EnvVar... env){
            if (this.env != null) {this.env.clear();}
            if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public Boolean hasEnv(){
            return env != null && !env.isEmpty();
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.duck.v1beta1.Destination getSink(){
            return this.sink!=null?this.sink.build():null;
    }

    public io.fabric8.knative.duck.v1beta1.Destination buildSink(){
            return this.sink!=null?this.sink.build():null;
    }

    public A withSink(io.fabric8.knative.duck.v1beta1.Destination sink){
            _visitables.get("sink").remove(this.sink);
            if (sink!=null){ this.sink= new io.fabric8.knative.duck.v1beta1.DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink(){
            return this.sink != null;
    }

    public ContainerSourceSpecFluent.V1beta1SinkNested<A> withNewV1beta1Sink(){
            return new V1beta1SinkNestedImpl();
    }

    public ContainerSourceSpecFluent.V1beta1SinkNested<A> withNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item){
            return new V1beta1SinkNestedImpl(item);
    }

    public ContainerSourceSpecFluent.V1beta1SinkNested<A> editV1beta1Sink(){
            return withNewSinkLike(getSink());
    }

    public ContainerSourceSpecFluent.V1beta1SinkNested<A> editOrNewSink(){
            return withNewSinkLike(getSink() != null ? getSink(): new io.fabric8.knative.duck.v1beta1.DestinationBuilder().build());
    }

    public ContainerSourceSpecFluent.V1beta1SinkNested<A> editOrNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item){
            return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public PodTemplateSpec getTemplate(){
            return this.template;
    }

    public A withTemplate(PodTemplateSpec template){
            this.template=template; return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ContainerSourceSpecFluentImpl that = (ContainerSourceSpecFluentImpl) o;
            if (args != null ? !args.equals(that.args) :that.args != null) return false;
            if (env != null ? !env.equals(that.env) :that.env != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class V1beta1SinkNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.DestinationFluentImpl<ContainerSourceSpecFluent.V1beta1SinkNested<N>> implements ContainerSourceSpecFluent.V1beta1SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.DestinationBuilder builder;
    
            V1beta1SinkNestedImpl(io.fabric8.knative.duck.v1beta1.Destination item){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DestinationBuilder(this, item);
            }
            V1beta1SinkNestedImpl(){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DestinationBuilder(this);
            }
    
    public N and(){
            return (N) ContainerSourceSpecFluentImpl.this.withSink(builder.build());
    }
    public N endV1beta1Sink(){
            return and();
    }

}


}
