package io.fabric8.knative.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolatileTimeBuilder extends VolatileTimeFluentImpl<VolatileTimeBuilder> implements VisitableBuilder<VolatileTime,VolatileTimeBuilder>{

    VolatileTimeFluent<?> fluent;
    Boolean validationEnabled;

    public VolatileTimeBuilder(){
            this(true);
    }
    public VolatileTimeBuilder(Boolean validationEnabled){
            this(new VolatileTime(), validationEnabled);
    }
    public VolatileTimeBuilder(VolatileTimeFluent<?> fluent){
            this(fluent, true);
    }
    public VolatileTimeBuilder(VolatileTimeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VolatileTime(), validationEnabled);
    }
    public VolatileTimeBuilder(VolatileTimeFluent<?> fluent,VolatileTime instance){
            this(fluent, instance, true);
    }
    public VolatileTimeBuilder(VolatileTimeFluent<?> fluent,VolatileTime instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withInner(instance.getInner()); 
            this.validationEnabled = validationEnabled; 
    }
    public VolatileTimeBuilder(VolatileTime instance){
            this(instance,true);
    }
    public VolatileTimeBuilder(VolatileTime instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withInner(instance.getInner()); 
            this.validationEnabled = validationEnabled; 
    }

    public VolatileTime build(){
            VolatileTime buildable = new VolatileTime(fluent.getInner());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VolatileTimeBuilder that = (VolatileTimeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
