package io.fabric8.knative.duck.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class ChannelableFluentImpl<A extends ChannelableFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelableFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ChannelableSpecBuilder spec;
    private ChannelableStatusBuilder status;

    public ChannelableFluentImpl(){
    }
    public ChannelableFluentImpl(Channelable instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ChannelableFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ChannelableFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ChannelableFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ChannelableFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ChannelableFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ChannelableSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ChannelableSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ChannelableSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new ChannelableSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public ChannelableFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ChannelableFluent.SpecNested<A> withNewSpecLike(ChannelableSpec item){
            return new SpecNestedImpl(item);
    }

    public ChannelableFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ChannelableFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ChannelableSpecBuilder().build());
    }

    public ChannelableFluent.SpecNested<A> editOrNewSpecLike(ChannelableSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ChannelableStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public ChannelableStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(ChannelableStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new ChannelableStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public ChannelableFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public ChannelableFluent.StatusNested<A> withNewStatusLike(ChannelableStatus item){
            return new StatusNestedImpl(item);
    }

    public ChannelableFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public ChannelableFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new ChannelableStatusBuilder().build());
    }

    public ChannelableFluent.StatusNested<A> editOrNewStatusLike(ChannelableStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelableFluentImpl that = (ChannelableFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ChannelableFluent.MetadataNested<N>> implements ChannelableFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ChannelableSpecFluentImpl<ChannelableFluent.SpecNested<N>> implements ChannelableFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelableSpecBuilder builder;
    
            SpecNestedImpl(ChannelableSpec item){
                    this.builder = new ChannelableSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ChannelableSpecBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends ChannelableStatusFluentImpl<ChannelableFluent.StatusNested<N>> implements ChannelableFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelableStatusBuilder builder;
    
            StatusNestedImpl(ChannelableStatus item){
                    this.builder = new ChannelableStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new ChannelableStatusBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
