package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceBuilder extends ResourceFluentImpl<ResourceBuilder> implements VisitableBuilder<Resource,ResourceBuilder>{

    ResourceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceBuilder(){
            this(true);
    }
    public ResourceBuilder(Boolean validationEnabled){
            this(new Resource(), validationEnabled);
    }
    public ResourceBuilder(ResourceFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceBuilder(ResourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Resource(), validationEnabled);
    }
    public ResourceBuilder(ResourceFluent<?> fluent,Resource instance){
            this(fluent, instance, true);
    }
    public ResourceBuilder(ResourceFluent<?> fluent,Resource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceBuilder(Resource instance){
            this(instance,true);
    }
    public ResourceBuilder(Resource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public Resource build(){
            Resource buildable = new Resource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceBuilder that = (ResourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
