package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableTypeListBuilder extends SubscribableTypeListFluentImpl<SubscribableTypeListBuilder> implements VisitableBuilder<SubscribableTypeList,SubscribableTypeListBuilder>{

    SubscribableTypeListFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableTypeListBuilder(){
            this(true);
    }
    public SubscribableTypeListBuilder(Boolean validationEnabled){
            this(new SubscribableTypeList(), validationEnabled);
    }
    public SubscribableTypeListBuilder(SubscribableTypeListFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableTypeListBuilder(SubscribableTypeListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableTypeList(), validationEnabled);
    }
    public SubscribableTypeListBuilder(SubscribableTypeListFluent<?> fluent,SubscribableTypeList instance){
            this(fluent, instance, true);
    }
    public SubscribableTypeListBuilder(SubscribableTypeListFluent<?> fluent,SubscribableTypeList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableTypeListBuilder(SubscribableTypeList instance){
            this(instance,true);
    }
    public SubscribableTypeListBuilder(SubscribableTypeList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscribableTypeList build(){
            SubscribableTypeList buildable = new SubscribableTypeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableTypeListBuilder that = (SubscribableTypeListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
