package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpec;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.duck.v1.DestinationFluentImpl;

public class ParallelSpecFluentImpl<A extends ParallelSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ParallelSpecFluent<A>{

    private List<ParallelBranchBuilder> branches;
    private ChannelTemplateSpecBuilder channelTemplate;
    private DestinationBuilder reply;

    public ParallelSpecFluentImpl(){
    }
    public ParallelSpecFluentImpl(ParallelSpec instance){
            this.withBranches(instance.getBranches()); 
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withReply(instance.getReply()); 
    }

    public A addToBranches(int index,ParallelBranch item){
            if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(index >= 0 ? index : _visitables.get("branches").size(), builder);this.branches.add(index >= 0 ? index : branches.size(), builder); return (A)this;
    }

    public A setToBranches(int index,ParallelBranch item){
            if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            if (index < 0 || index >= _visitables.get("branches").size()) { _visitables.get("branches").add(builder); } else { _visitables.get("branches").set(index, builder);}
            if (index < 0 || index >= branches.size()) { branches.add(builder); } else { branches.set(index, builder);}
             return (A)this;
    }

    public A addToBranches(ParallelBranch... items){
            if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
            for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
    }

    public A addAllToBranches(Collection<ParallelBranch> items){
            if (this.branches == null) {this.branches = new ArrayList<ParallelBranchBuilder>();}
            for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").add(builder);this.branches.add(builder);} return (A)this;
    }

    public A removeFromBranches(ParallelBranch... items){
            for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").remove(builder);if (this.branches != null) {this.branches.remove(builder);}} return (A)this;
    }

    public A removeAllFromBranches(Collection<ParallelBranch> items){
            for (ParallelBranch item : items) {ParallelBranchBuilder builder = new ParallelBranchBuilder(item);_visitables.get("branches").remove(builder);if (this.branches != null) {this.branches.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBranches(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchBuilder> predicate){
            if (branches == null) return (A) this;
            final Iterator<ParallelBranchBuilder> each = branches.iterator();
            final List visitables = _visitables.get("branches");
            while (each.hasNext()) {
              ParallelBranchBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBranches instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<ParallelBranch> getBranches(){
            return build(branches);
    }

    public List<ParallelBranch> buildBranches(){
            return build(branches);
    }

    public ParallelBranch buildBranch(int index){
            return this.branches.get(index).build();
    }

    public ParallelBranch buildFirstBranch(){
            return this.branches.get(0).build();
    }

    public ParallelBranch buildLastBranch(){
            return this.branches.get(branches.size() - 1).build();
    }

    public ParallelBranch buildMatchingBranch(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchBuilder> predicate){
            for (ParallelBranchBuilder item: branches) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBranch(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchBuilder> predicate){
            for (ParallelBranchBuilder item: branches) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBranches(List<ParallelBranch> branches){
            if (this.branches != null) { _visitables.get("branches").removeAll(this.branches);}
            if (branches != null) {this.branches = new ArrayList<ParallelBranchBuilder>(); for (ParallelBranch item : branches){this.addToBranches(item);}} else { this.branches = null;} return (A) this;
    }

    public A withBranches(ParallelBranch... branches){
            if (this.branches != null) {this.branches.clear();}
            if (branches != null) {for (ParallelBranch item :branches){ this.addToBranches(item);}} return (A) this;
    }

    public Boolean hasBranches(){
            return branches != null && !branches.isEmpty();
    }

    public ParallelSpecFluent.BranchesNested<A> addNewBranch(){
            return new BranchesNestedImpl();
    }

    public ParallelSpecFluent.BranchesNested<A> addNewBranchLike(ParallelBranch item){
            return new BranchesNestedImpl(-1, item);
    }

    public ParallelSpecFluent.BranchesNested<A> setNewBranchLike(int index,ParallelBranch item){
            return new BranchesNestedImpl(index, item);
    }

    public ParallelSpecFluent.BranchesNested<A> editBranch(int index){
            if (branches.size() <= index) throw new RuntimeException("Can't edit branches. Index exceeds size.");
            return setNewBranchLike(index, buildBranch(index));
    }

    public ParallelSpecFluent.BranchesNested<A> editFirstBranch(){
            if (branches.size() == 0) throw new RuntimeException("Can't edit first branches. The list is empty.");
            return setNewBranchLike(0, buildBranch(0));
    }

    public ParallelSpecFluent.BranchesNested<A> editLastBranch(){
            int index = branches.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last branches. The list is empty.");
            return setNewBranchLike(index, buildBranch(index));
    }

    public ParallelSpecFluent.BranchesNested<A> editMatchingBranch(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchBuilder> predicate){
            int index = -1;
            for (int i=0;i<branches.size();i++) { 
            if (predicate.apply(branches.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching branches. No match found.");
            return setNewBranchLike(index, buildBranch(index));
    }

    
/**
 * This method has been deprecated, please use method buildChannelTemplate instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ChannelTemplateSpec getChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public ChannelTemplateSpec buildChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(ChannelTemplateSpec channelTemplate){
            _visitables.get("channelTemplate").remove(this.channelTemplate);
            if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public Boolean hasChannelTemplate(){
            return this.channelTemplate != null;
    }

    public ParallelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate(){
            return new ChannelTemplateNestedImpl();
    }

    public ParallelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item){
            return new ChannelTemplateNestedImpl(item);
    }

    public ParallelSpecFluent.ChannelTemplateNested<A> editChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate());
    }

    public ParallelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new ChannelTemplateSpecBuilder().build());
    }

    public ParallelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Destination getReply(){
            return this.reply!=null?this.reply.build():null;
    }

    public Destination buildReply(){
            return this.reply!=null?this.reply.build():null;
    }

    public A withReply(Destination reply){
            _visitables.get("reply").remove(this.reply);
            if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public Boolean hasReply(){
            return this.reply != null;
    }

    public ParallelSpecFluent.ReplyNested<A> withNewReply(){
            return new ReplyNestedImpl();
    }

    public ParallelSpecFluent.ReplyNested<A> withNewReplyLike(Destination item){
            return new ReplyNestedImpl(item);
    }

    public ParallelSpecFluent.ReplyNested<A> editReply(){
            return withNewReplyLike(getReply());
    }

    public ParallelSpecFluent.ReplyNested<A> editOrNewReply(){
            return withNewReplyLike(getReply() != null ? getReply(): new DestinationBuilder().build());
    }

    public ParallelSpecFluent.ReplyNested<A> editOrNewReplyLike(Destination item){
            return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ParallelSpecFluentImpl that = (ParallelSpecFluentImpl) o;
            if (branches != null ? !branches.equals(that.branches) :that.branches != null) return false;
            if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
            if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
            return true;
    }


    public class BranchesNestedImpl<N> extends ParallelBranchFluentImpl<ParallelSpecFluent.BranchesNested<N>> implements ParallelSpecFluent.BranchesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParallelBranchBuilder builder;
        private final int index;
    
            BranchesNestedImpl(int index,ParallelBranch item){
                    this.index = index;
                    this.builder = new ParallelBranchBuilder(this, item);
            }
            BranchesNestedImpl(){
                    this.index = -1;
                    this.builder = new ParallelBranchBuilder(this);
            }
    
    public N and(){
            return (N) ParallelSpecFluentImpl.this.setToBranches(index,builder.build());
    }
    public N endBranch(){
            return and();
    }

}
    public class ChannelTemplateNestedImpl<N> extends ChannelTemplateSpecFluentImpl<ParallelSpecFluent.ChannelTemplateNested<N>> implements ParallelSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelTemplateSpecBuilder builder;
    
            ChannelTemplateNestedImpl(ChannelTemplateSpec item){
                    this.builder = new ChannelTemplateSpecBuilder(this, item);
            }
            ChannelTemplateNestedImpl(){
                    this.builder = new ChannelTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ParallelSpecFluentImpl.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate(){
            return and();
    }

}
    public class ReplyNestedImpl<N> extends DestinationFluentImpl<ParallelSpecFluent.ReplyNested<N>> implements ParallelSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationBuilder builder;
    
            ReplyNestedImpl(Destination item){
                    this.builder = new DestinationBuilder(this, item);
            }
            ReplyNestedImpl(){
                    this.builder = new DestinationBuilder(this);
            }
    
    public N and(){
            return (N) ParallelSpecFluentImpl.this.withReply(builder.build());
    }
    public N endReply(){
            return and();
    }

}


}
