package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface SequenceFluent<A extends SequenceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public SequenceFluent.MetadataNested<A> withNewMetadata();
    public SequenceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SequenceFluent.MetadataNested<A> editMetadata();
    public SequenceFluent.MetadataNested<A> editOrNewMetadata();
    public SequenceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public SequenceSpec getSpec();
    public SequenceSpec buildSpec();
    public A withSpec(SequenceSpec spec);
    public Boolean hasSpec();
    public SequenceFluent.SpecNested<A> withNewSpec();
    public SequenceFluent.SpecNested<A> withNewSpecLike(SequenceSpec item);
    public SequenceFluent.SpecNested<A> editSpec();
    public SequenceFluent.SpecNested<A> editOrNewSpec();
    public SequenceFluent.SpecNested<A> editOrNewSpecLike(SequenceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public SequenceStatus getStatus();
    public SequenceStatus buildStatus();
    public A withStatus(SequenceStatus status);
    public Boolean hasStatus();
    public SequenceFluent.StatusNested<A> withNewStatus();
    public SequenceFluent.StatusNested<A> withNewStatusLike(SequenceStatus item);
    public SequenceFluent.StatusNested<A> editStatus();
    public SequenceFluent.StatusNested<A> editOrNewStatus();
    public SequenceFluent.StatusNested<A> editOrNewStatusLike(SequenceStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<SequenceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SequenceSpecFluent<SequenceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SequenceStatusFluent<SequenceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
