package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.model.OwnerReference;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ApiServerResourceFluentImpl<A extends ApiServerResourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ApiServerResourceFluent<A>{

    private String apiVersion;
    private Boolean controller;
    private OwnerReference controllerSelector;
    private String kind;
    private LabelSelector labelSelector;

    public ApiServerResourceFluentImpl(){
    }
    public ApiServerResourceFluentImpl(ApiServerResource instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withController(instance.getController()); 
            this.withControllerSelector(instance.getControllerSelector()); 
            this.withKind(instance.getKind()); 
            this.withLabelSelector(instance.getLabelSelector()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public Boolean isController(){
            return this.controller;
    }

    public A withController(Boolean controller){
            this.controller=controller; return (A) this;
    }

    public Boolean hasController(){
            return this.controller != null;
    }

    public A withNewController(String arg1){
            return (A)withController(new Boolean(arg1));
    }

    public A withNewController(boolean arg1){
            return (A)withController(new Boolean(arg1));
    }

    public OwnerReference getControllerSelector(){
            return this.controllerSelector;
    }

    public A withControllerSelector(OwnerReference controllerSelector){
            this.controllerSelector=controllerSelector; return (A) this;
    }

    public Boolean hasControllerSelector(){
            return this.controllerSelector != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public LabelSelector getLabelSelector(){
            return this.labelSelector;
    }

    public A withLabelSelector(LabelSelector labelSelector){
            this.labelSelector=labelSelector; return (A) this;
    }

    public Boolean hasLabelSelector(){
            return this.labelSelector != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ApiServerResourceFluentImpl that = (ApiServerResourceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (controller != null ? !controller.equals(that.controller) :that.controller != null) return false;
            if (controllerSelector != null ? !controllerSelector.equals(that.controllerSelector) :that.controllerSelector != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
            return true;
    }




}
