package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PinnedTypeBuilder extends PinnedTypeFluentImpl<PinnedTypeBuilder> implements VisitableBuilder<PinnedType,PinnedTypeBuilder>{

    PinnedTypeFluent<?> fluent;
    Boolean validationEnabled;

    public PinnedTypeBuilder(){
            this(true);
    }
    public PinnedTypeBuilder(Boolean validationEnabled){
            this(new PinnedType(), validationEnabled);
    }
    public PinnedTypeBuilder(PinnedTypeFluent<?> fluent){
            this(fluent, true);
    }
    public PinnedTypeBuilder(PinnedTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PinnedType(), validationEnabled);
    }
    public PinnedTypeBuilder(PinnedTypeFluent<?> fluent,PinnedType instance){
            this(fluent, instance, true);
    }
    public PinnedTypeBuilder(PinnedTypeFluent<?> fluent,PinnedType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfiguration(instance.getConfiguration()); 
            fluent.withRevisionName(instance.getRevisionName()); 
            this.validationEnabled = validationEnabled; 
    }
    public PinnedTypeBuilder(PinnedType instance){
            this(instance,true);
    }
    public PinnedTypeBuilder(PinnedType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfiguration(instance.getConfiguration()); 
            this.withRevisionName(instance.getRevisionName()); 
            this.validationEnabled = validationEnabled; 
    }

    public PinnedType build(){
            PinnedType buildable = new PinnedType(fluent.getConfiguration(),fluent.getRevisionName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PinnedTypeBuilder that = (PinnedTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
