package io.fabric8.knative.dev.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SubscribableFluent<A extends SubscribableFluent<A>> extends Fluent<A>{


    public A addToSubscribers(int index,SubscriberSpec item);
    public A setToSubscribers(int index,SubscriberSpec item);
    public A addToSubscribers(SubscriberSpec... items);
    public A addAllToSubscribers(Collection<SubscriberSpec> items);
    public A removeFromSubscribers(SubscriberSpec... items);
    public A removeAllFromSubscribers(Collection<SubscriberSpec> items);
    public A removeMatchingFromSubscribers(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<SubscriberSpec> getSubscribers();
    public List<SubscriberSpec> buildSubscribers();
    public SubscriberSpec buildSubscriber(int index);
    public SubscriberSpec buildFirstSubscriber();
    public SubscriberSpec buildLastSubscriber();
    public SubscriberSpec buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate);
    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate);
    public A withSubscribers(List<SubscriberSpec> subscribers);
    public A withSubscribers(SubscriberSpec... subscribers);
    public Boolean hasSubscribers();
    public SubscribableFluent.SubscribersNested<A> addNewSubscriber();
    public SubscribableFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item);
    public SubscribableFluent.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberSpec item);
    public SubscribableFluent.SubscribersNested<A> editSubscriber(int index);
    public SubscribableFluent.SubscribersNested<A> editFirstSubscriber();
    public SubscribableFluent.SubscribersNested<A> editLastSubscriber();
    public SubscribableFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate);

    public interface SubscribersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SubscriberSpecFluent<SubscribableFluent.SubscribersNested<N>>{

        
    public N and();    public N endSubscriber();
}


}
