package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceListBuilder extends ResourceListFluentImpl<ResourceListBuilder> implements VisitableBuilder<ResourceList,ResourceListBuilder>{

    ResourceListFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceListBuilder(){
            this(true);
    }
    public ResourceListBuilder(Boolean validationEnabled){
            this(new ResourceList(), validationEnabled);
    }
    public ResourceListBuilder(ResourceListFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceListBuilder(ResourceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceList(), validationEnabled);
    }
    public ResourceListBuilder(ResourceListFluent<?> fluent,ResourceList instance){
            this(fluent, instance, true);
    }
    public ResourceListBuilder(ResourceListFluent<?> fluent,ResourceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceListBuilder(ResourceList instance){
            this(instance,true);
    }
    public ResourceListBuilder(ResourceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ResourceList build(){
            ResourceList buildable = new ResourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceListBuilder that = (ResourceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
