package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelChannelStatusBuilder extends ParallelChannelStatusFluentImpl<ParallelChannelStatusBuilder> implements VisitableBuilder<ParallelChannelStatus,ParallelChannelStatusBuilder>{

    ParallelChannelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelChannelStatusBuilder(){
            this(true);
    }
    public ParallelChannelStatusBuilder(Boolean validationEnabled){
            this(new ParallelChannelStatus(), validationEnabled);
    }
    public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelChannelStatus(), validationEnabled);
    }
    public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent,ParallelChannelStatus instance){
            this(fluent, instance, true);
    }
    public ParallelChannelStatusBuilder(ParallelChannelStatusFluent<?> fluent,ParallelChannelStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withChannel(instance.getChannel()); 
            fluent.withReady(instance.getReady()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelChannelStatusBuilder(ParallelChannelStatus instance){
            this(instance,true);
    }
    public ParallelChannelStatusBuilder(ParallelChannelStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withChannel(instance.getChannel()); 
            this.withReady(instance.getReady()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelChannelStatus build(){
            ParallelChannelStatus buildable = new ParallelChannelStatus(fluent.getChannel(),fluent.getReady());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelChannelStatusBuilder that = (ParallelChannelStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
