package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ApiServerSourceBuilder extends ApiServerSourceFluentImpl<ApiServerSourceBuilder> implements VisitableBuilder<ApiServerSource,ApiServerSourceBuilder>{

    ApiServerSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ApiServerSourceBuilder(){
            this(true);
    }
    public ApiServerSourceBuilder(Boolean validationEnabled){
            this(new ApiServerSource(), validationEnabled);
    }
    public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent){
            this(fluent, true);
    }
    public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiServerSource(), validationEnabled);
    }
    public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent,ApiServerSource instance){
            this(fluent, instance, true);
    }
    public ApiServerSourceBuilder(ApiServerSourceFluent<?> fluent,ApiServerSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withDeprecated(instance.getDeprecated()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiServerSourceBuilder(ApiServerSource instance){
            this(instance,true);
    }
    public ApiServerSourceBuilder(ApiServerSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withDeprecated(instance.getDeprecated()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ApiServerSource build(){
            ApiServerSource buildable = new ApiServerSource(fluent.getApiVersion(),fluent.getDeprecated(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiServerSourceBuilder that = (ApiServerSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
