package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerSourceStatusBuilder extends ContainerSourceStatusFluentImpl<ContainerSourceStatusBuilder> implements VisitableBuilder<ContainerSourceStatus,ContainerSourceStatusBuilder>{

    ContainerSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerSourceStatusBuilder(){
            this(true);
    }
    public ContainerSourceStatusBuilder(Boolean validationEnabled){
            this(new ContainerSourceStatus(), validationEnabled);
    }
    public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerSourceStatus(), validationEnabled);
    }
    public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,ContainerSourceStatus instance){
            this(fluent, instance, true);
    }
    public ContainerSourceStatusBuilder(ContainerSourceStatusFluent<?> fluent,ContainerSourceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSinkUri(instance.getSinkUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerSourceStatusBuilder(ContainerSourceStatus instance){
            this(instance,true);
    }
    public ContainerSourceStatusBuilder(ContainerSourceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSinkUri(instance.getSinkUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public ContainerSourceStatus build(){
            ContainerSourceStatus buildable = new ContainerSourceStatus(fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerSourceStatusBuilder that = (ContainerSourceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
