package io.fabric8.knative.legacysources.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobResourceSpecFluentImpl<A extends CronJobResourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CronJobResourceSpecFluent<A>{

    private CronJobLimitsSpecBuilder limits;
    private CronJobRequestsSpecBuilder requests;

    public CronJobResourceSpecFluentImpl(){
    }
    public CronJobResourceSpecFluentImpl(CronJobResourceSpec instance){
            this.withLimits(instance.getLimits()); 
            this.withRequests(instance.getRequests()); 
    }

    
/**
 * This method has been deprecated, please use method buildLimits instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public CronJobLimitsSpec getLimits(){
            return this.limits!=null?this.limits.build():null;
    }

    public CronJobLimitsSpec buildLimits(){
            return this.limits!=null?this.limits.build():null;
    }

    public A withLimits(CronJobLimitsSpec limits){
            _visitables.get("limits").remove(this.limits);
            if (limits!=null){ this.limits= new CronJobLimitsSpecBuilder(limits); _visitables.get("limits").add(this.limits);} return (A) this;
    }

    public Boolean hasLimits(){
            return this.limits != null;
    }

    public A withNewLimits(String cpu,String memory){
            return (A)withLimits(new CronJobLimitsSpec(cpu, memory));
    }

    public CronJobResourceSpecFluent.LimitsNested<A> withNewLimits(){
            return new LimitsNestedImpl();
    }

    public CronJobResourceSpecFluent.LimitsNested<A> withNewLimitsLike(CronJobLimitsSpec item){
            return new LimitsNestedImpl(item);
    }

    public CronJobResourceSpecFluent.LimitsNested<A> editLimits(){
            return withNewLimitsLike(getLimits());
    }

    public CronJobResourceSpecFluent.LimitsNested<A> editOrNewLimits(){
            return withNewLimitsLike(getLimits() != null ? getLimits(): new CronJobLimitsSpecBuilder().build());
    }

    public CronJobResourceSpecFluent.LimitsNested<A> editOrNewLimitsLike(CronJobLimitsSpec item){
            return withNewLimitsLike(getLimits() != null ? getLimits(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRequests instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public CronJobRequestsSpec getRequests(){
            return this.requests!=null?this.requests.build():null;
    }

    public CronJobRequestsSpec buildRequests(){
            return this.requests!=null?this.requests.build():null;
    }

    public A withRequests(CronJobRequestsSpec requests){
            _visitables.get("requests").remove(this.requests);
            if (requests!=null){ this.requests= new CronJobRequestsSpecBuilder(requests); _visitables.get("requests").add(this.requests);} return (A) this;
    }

    public Boolean hasRequests(){
            return this.requests != null;
    }

    public A withNewRequests(String cpu,String memory){
            return (A)withRequests(new CronJobRequestsSpec(cpu, memory));
    }

    public CronJobResourceSpecFluent.RequestsNested<A> withNewRequests(){
            return new RequestsNestedImpl();
    }

    public CronJobResourceSpecFluent.RequestsNested<A> withNewRequestsLike(CronJobRequestsSpec item){
            return new RequestsNestedImpl(item);
    }

    public CronJobResourceSpecFluent.RequestsNested<A> editRequests(){
            return withNewRequestsLike(getRequests());
    }

    public CronJobResourceSpecFluent.RequestsNested<A> editOrNewRequests(){
            return withNewRequestsLike(getRequests() != null ? getRequests(): new CronJobRequestsSpecBuilder().build());
    }

    public CronJobResourceSpecFluent.RequestsNested<A> editOrNewRequestsLike(CronJobRequestsSpec item){
            return withNewRequestsLike(getRequests() != null ? getRequests(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CronJobResourceSpecFluentImpl that = (CronJobResourceSpecFluentImpl) o;
            if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
            if (requests != null ? !requests.equals(that.requests) :that.requests != null) return false;
            return true;
    }


    public class LimitsNestedImpl<N> extends CronJobLimitsSpecFluentImpl<CronJobResourceSpecFluent.LimitsNested<N>> implements CronJobResourceSpecFluent.LimitsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CronJobLimitsSpecBuilder builder;
    
            LimitsNestedImpl(CronJobLimitsSpec item){
                    this.builder = new CronJobLimitsSpecBuilder(this, item);
            }
            LimitsNestedImpl(){
                    this.builder = new CronJobLimitsSpecBuilder(this);
            }
    
    public N and(){
            return (N) CronJobResourceSpecFluentImpl.this.withLimits(builder.build());
    }
    public N endLimits(){
            return and();
    }

}
    public class RequestsNestedImpl<N> extends CronJobRequestsSpecFluentImpl<CronJobResourceSpecFluent.RequestsNested<N>> implements CronJobResourceSpecFluent.RequestsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CronJobRequestsSpecBuilder builder;
    
            RequestsNestedImpl(CronJobRequestsSpec item){
                    this.builder = new CronJobRequestsSpecBuilder(this, item);
            }
            RequestsNestedImpl(){
                    this.builder = new CronJobRequestsSpecBuilder(this);
            }
    
    public N and(){
            return (N) CronJobResourceSpecFluentImpl.this.withRequests(builder.build());
    }
    public N endRequests(){
            return and();
    }

}


}
