package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobSourceStatusBuilder extends CronJobSourceStatusFluentImpl<CronJobSourceStatusBuilder> implements VisitableBuilder<CronJobSourceStatus,CronJobSourceStatusBuilder>{

    CronJobSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobSourceStatusBuilder(){
            this(true);
    }
    public CronJobSourceStatusBuilder(Boolean validationEnabled){
            this(new CronJobSourceStatus(), validationEnabled);
    }
    public CronJobSourceStatusBuilder(CronJobSourceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public CronJobSourceStatusBuilder(CronJobSourceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CronJobSourceStatus(), validationEnabled);
    }
    public CronJobSourceStatusBuilder(CronJobSourceStatusFluent<?> fluent,CronJobSourceStatus instance){
            this(fluent, instance, true);
    }
    public CronJobSourceStatusBuilder(CronJobSourceStatusFluent<?> fluent,CronJobSourceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSinkUri(instance.getSinkUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public CronJobSourceStatusBuilder(CronJobSourceStatus instance){
            this(instance,true);
    }
    public CronJobSourceStatusBuilder(CronJobSourceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSinkUri(instance.getSinkUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public CronJobSourceStatus build(){
            CronJobSourceStatus buildable = new CronJobSourceStatus(fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CronJobSourceStatusBuilder that = (CronJobSourceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
