package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpecBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpec;

public class SubscriberSpecFluentImpl<A extends SubscriberSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriberSpecFluent<A>{

    private String deadLetterSink;
    private DeliverySpecBuilder delivery;
    private Long generation;
    private String replyURI;
    private String subscriberURI;
    private String uid;

    public SubscriberSpecFluentImpl(){
    }
    public SubscriberSpecFluentImpl(SubscriberSpec instance){
            this.withDeadLetterSink(instance.getDeadLetterSink()); 
            this.withDelivery(instance.getDelivery()); 
            this.withGeneration(instance.getGeneration()); 
            this.withReplyURI(instance.getReplyURI()); 
            this.withSubscriberURI(instance.getSubscriberURI()); 
            this.withUid(instance.getUid()); 
    }

    public String getDeadLetterSink(){
            return this.deadLetterSink;
    }

    public A withDeadLetterSink(String deadLetterSink){
            this.deadLetterSink=deadLetterSink; return (A) this;
    }

    public Boolean hasDeadLetterSink(){
            return this.deadLetterSink != null;
    }

    public A withNewDeadLetterSink(String arg1){
            return (A)withDeadLetterSink(new String(arg1));
    }

    public A withNewDeadLetterSink(StringBuilder arg1){
            return (A)withDeadLetterSink(new String(arg1));
    }

    public A withNewDeadLetterSink(StringBuffer arg1){
            return (A)withDeadLetterSink(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery){
            _visitables.get("delivery").remove(this.delivery);
            if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery(){
            return this.delivery != null;
    }

    public SubscriberSpecFluent.DeliveryNested<A> withNewDelivery(){
            return new DeliveryNestedImpl();
    }

    public SubscriberSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item){
            return new DeliveryNestedImpl(item);
    }

    public SubscriberSpecFluent.DeliveryNested<A> editDelivery(){
            return withNewDeliveryLike(getDelivery());
    }

    public SubscriberSpecFluent.DeliveryNested<A> editOrNewDelivery(){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public SubscriberSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    public String getReplyURI(){
            return this.replyURI;
    }

    public A withReplyURI(String replyURI){
            this.replyURI=replyURI; return (A) this;
    }

    public Boolean hasReplyURI(){
            return this.replyURI != null;
    }

    public A withNewReplyURI(String arg1){
            return (A)withReplyURI(new String(arg1));
    }

    public A withNewReplyURI(StringBuilder arg1){
            return (A)withReplyURI(new String(arg1));
    }

    public A withNewReplyURI(StringBuffer arg1){
            return (A)withReplyURI(new String(arg1));
    }

    public String getSubscriberURI(){
            return this.subscriberURI;
    }

    public A withSubscriberURI(String subscriberURI){
            this.subscriberURI=subscriberURI; return (A) this;
    }

    public Boolean hasSubscriberURI(){
            return this.subscriberURI != null;
    }

    public A withNewSubscriberURI(String arg1){
            return (A)withSubscriberURI(new String(arg1));
    }

    public A withNewSubscriberURI(StringBuilder arg1){
            return (A)withSubscriberURI(new String(arg1));
    }

    public A withNewSubscriberURI(StringBuffer arg1){
            return (A)withSubscriberURI(new String(arg1));
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public A withNewUid(String arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1){
            return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubscriberSpecFluentImpl that = (SubscriberSpecFluentImpl) o;
            if (deadLetterSink != null ? !deadLetterSink.equals(that.deadLetterSink) :that.deadLetterSink != null) return false;
            if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (replyURI != null ? !replyURI.equals(that.replyURI) :that.replyURI != null) return false;
            if (subscriberURI != null ? !subscriberURI.equals(that.subscriberURI) :that.subscriberURI != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            return true;
    }


    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<SubscriberSpecFluent.DeliveryNested<N>> implements SubscriberSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeliverySpecBuilder builder;
    
            DeliveryNestedImpl(DeliverySpec item){
                    this.builder = new DeliverySpecBuilder(this, item);
            }
            DeliveryNestedImpl(){
                    this.builder = new DeliverySpecBuilder(this);
            }
    
    public N and(){
            return (N) SubscriberSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery(){
            return and();
    }

}


}
