package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.SubscribableStatusFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.SubscribableStatus;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.SubscribableStatusBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class ChannelStatusFluentImpl<A extends ChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelStatusFluent<A>{

    private io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder address;
    private ObjectReference channel;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;
    private SubscribableStatusBuilder subscribableStatus;

    public ChannelStatusFluentImpl(){
    }
    public ChannelStatusFluentImpl(ChannelStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withChannel(instance.getChannel()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribableStatus(instance.getSubscribableStatus()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewV1alpha1Address(String hostname,String url){
            return (A)withAddress(new Addressable(hostname, url));
    }

    public ChannelStatusFluent.V1alpha1AddressNested<A> withNewV1alpha1Address(){
            return new V1alpha1AddressNestedImpl();
    }

    public ChannelStatusFluent.V1alpha1AddressNested<A> withNewAddressLike(io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable item){
            return new V1alpha1AddressNestedImpl(item);
    }

    public ChannelStatusFluent.V1alpha1AddressNested<A> editV1alpha1Address(){
            return withNewAddressLike(getAddress());
    }

    public ChannelStatusFluent.V1alpha1AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder().build());
    }

    public ChannelStatusFluent.V1alpha1AddressNested<A> editOrNewAddressLike(io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public ObjectReference getChannel(){
            return this.channel;
    }

    public A withChannel(ObjectReference channel){
            this.channel=channel; return (A) this;
    }

    public Boolean hasChannel(){
            return this.channel != null;
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<ConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              ConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public ChannelStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ChannelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public ChannelStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public ChannelStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ChannelStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public ChannelStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ChannelStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribableStatus instead.
 * @return The buildable object.
 */
@Deprecated public SubscribableStatus getSubscribableStatus(){
            return this.subscribableStatus!=null?this.subscribableStatus.build():null;
    }

    public SubscribableStatus buildSubscribableStatus(){
            return this.subscribableStatus!=null?this.subscribableStatus.build():null;
    }

    public A withSubscribableStatus(SubscribableStatus subscribableStatus){
            _visitables.get("subscribableStatus").remove(this.subscribableStatus);
            if (subscribableStatus!=null){ this.subscribableStatus= new SubscribableStatusBuilder(subscribableStatus); _visitables.get("subscribableStatus").add(this.subscribableStatus);} return (A) this;
    }

    public Boolean hasSubscribableStatus(){
            return this.subscribableStatus != null;
    }

    public ChannelStatusFluent.SubscribableStatusNested<A> withNewSubscribableStatus(){
            return new SubscribableStatusNestedImpl();
    }

    public ChannelStatusFluent.SubscribableStatusNested<A> withNewSubscribableStatusLike(SubscribableStatus item){
            return new SubscribableStatusNestedImpl(item);
    }

    public ChannelStatusFluent.SubscribableStatusNested<A> editSubscribableStatus(){
            return withNewSubscribableStatusLike(getSubscribableStatus());
    }

    public ChannelStatusFluent.SubscribableStatusNested<A> editOrNewSubscribableStatus(){
            return withNewSubscribableStatusLike(getSubscribableStatus() != null ? getSubscribableStatus(): new SubscribableStatusBuilder().build());
    }

    public ChannelStatusFluent.SubscribableStatusNested<A> editOrNewSubscribableStatusLike(SubscribableStatus item){
            return withNewSubscribableStatusLike(getSubscribableStatus() != null ? getSubscribableStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelStatusFluentImpl that = (ChannelStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (subscribableStatus != null ? !subscribableStatus.equals(that.subscribableStatus) :that.subscribableStatus != null) return false;
            return true;
    }


    public class V1alpha1AddressNestedImpl<N> extends io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableFluentImpl<ChannelStatusFluent.V1alpha1AddressNested<N>> implements ChannelStatusFluent.V1alpha1AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder builder;
    
            V1alpha1AddressNestedImpl(io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.Addressable item){
                    this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder(this, item);
            }
            V1alpha1AddressNestedImpl(){
                    this.builder = new io.fabric8.knative.internal.pkg.apis.duck.v1alpha1.AddressableBuilder(this);
            }
    
    public N and(){
            return (N) ChannelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endV1alpha1Address(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<ChannelStatusFluent.ConditionsNested<N>> implements ChannelStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) ChannelStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class SubscribableStatusNestedImpl<N> extends SubscribableStatusFluentImpl<ChannelStatusFluent.SubscribableStatusNested<N>> implements ChannelStatusFluent.SubscribableStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscribableStatusBuilder builder;
    
            SubscribableStatusNestedImpl(SubscribableStatus item){
                    this.builder = new SubscribableStatusBuilder(this, item);
            }
            SubscribableStatusNestedImpl(){
                    this.builder = new SubscribableStatusBuilder(this);
            }
    
    public N and(){
            return (N) ChannelStatusFluentImpl.this.withSubscribableStatus(builder.build());
    }
    public N endSubscribableStatus(){
            return and();
    }

}


}
