package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerFilterBuilder extends TriggerFilterFluentImpl<TriggerFilterBuilder> implements VisitableBuilder<TriggerFilter,TriggerFilterBuilder>{

    TriggerFilterFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerFilterBuilder(){
            this(true);
    }
    public TriggerFilterBuilder(Boolean validationEnabled){
            this(new TriggerFilter(), validationEnabled);
    }
    public TriggerFilterBuilder(TriggerFilterFluent<?> fluent){
            this(fluent, true);
    }
    public TriggerFilterBuilder(TriggerFilterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TriggerFilter(), validationEnabled);
    }
    public TriggerFilterBuilder(TriggerFilterFluent<?> fluent,TriggerFilter instance){
            this(fluent, instance, true);
    }
    public TriggerFilterBuilder(TriggerFilterFluent<?> fluent,TriggerFilter instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withSourceAndType(instance.getSourceAndType()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerFilterBuilder(TriggerFilter instance){
            this(instance,true);
    }
    public TriggerFilterBuilder(TriggerFilter instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributes(instance.getAttributes()); 
            this.withSourceAndType(instance.getSourceAndType()); 
            this.validationEnabled = validationEnabled; 
    }

    public TriggerFilter build(){
            TriggerFilter buildable = new TriggerFilter(fluent.getAttributes(),fluent.getSourceAndType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TriggerFilterBuilder that = (TriggerFilterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
