package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class SequenceStatusFluentImpl<A extends SequenceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceStatusFluent<A>{

    private AddressableBuilder address;
    private List<SequenceChannelStatusBuilder> channelStatuses;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;
    private List<SequenceSubscriptionStatusBuilder> subscriptionStatuses;

    public SequenceStatusFluentImpl(){
    }
    public SequenceStatusFluentImpl(SequenceStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withChannelStatuses(instance.getChannelStatuses()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String url){
            return (A)withAddress(new Addressable(url));
    }

    public SequenceStatusFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public SequenceStatusFluent.AddressNested<A> withNewAddressLike(Addressable item){
            return new AddressNestedImpl(item);
    }

    public SequenceStatusFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public SequenceStatusFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public SequenceStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToChannelStatuses(int index,SequenceChannelStatus item){
            if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
            SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(index >= 0 ? index : _visitables.get("channelStatuses").size(), builder);this.channelStatuses.add(index >= 0 ? index : channelStatuses.size(), builder); return (A)this;
    }

    public A setToChannelStatuses(int index,SequenceChannelStatus item){
            if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
            SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("channelStatuses").size()) { _visitables.get("channelStatuses").add(builder); } else { _visitables.get("channelStatuses").set(index, builder);}
            if (index < 0 || index >= channelStatuses.size()) { channelStatuses.add(builder); } else { channelStatuses.set(index, builder);}
             return (A)this;
    }

    public A addToChannelStatuses(SequenceChannelStatus... items){
            if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
            for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(builder);this.channelStatuses.add(builder);} return (A)this;
    }

    public A addAllToChannelStatuses(Collection<SequenceChannelStatus> items){
            if (this.channelStatuses == null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>();}
            for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").add(builder);this.channelStatuses.add(builder);} return (A)this;
    }

    public A removeFromChannelStatuses(SequenceChannelStatus... items){
            for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").remove(builder);if (this.channelStatuses != null) {this.channelStatuses.remove(builder);}} return (A)this;
    }

    public A removeAllFromChannelStatuses(Collection<SequenceChannelStatus> items){
            for (SequenceChannelStatus item : items) {SequenceChannelStatusBuilder builder = new SequenceChannelStatusBuilder(item);_visitables.get("channelStatuses").remove(builder);if (this.channelStatuses != null) {this.channelStatuses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromChannelStatuses(io.fabric8.kubernetes.api.builder.Predicate<SequenceChannelStatusBuilder> predicate){
            if (channelStatuses == null) return (A) this;
            final Iterator<SequenceChannelStatusBuilder> each = channelStatuses.iterator();
            final List visitables = _visitables.get("channelStatuses");
            while (each.hasNext()) {
              SequenceChannelStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildChannelStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<SequenceChannelStatus> getChannelStatuses(){
            return build(channelStatuses);
    }

    public List<SequenceChannelStatus> buildChannelStatuses(){
            return build(channelStatuses);
    }

    public SequenceChannelStatus buildChannelStatus(int index){
            return this.channelStatuses.get(index).build();
    }

    public SequenceChannelStatus buildFirstChannelStatus(){
            return this.channelStatuses.get(0).build();
    }

    public SequenceChannelStatus buildLastChannelStatus(){
            return this.channelStatuses.get(channelStatuses.size() - 1).build();
    }

    public SequenceChannelStatus buildMatchingChannelStatus(io.fabric8.kubernetes.api.builder.Predicate<SequenceChannelStatusBuilder> predicate){
            for (SequenceChannelStatusBuilder item: channelStatuses) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingChannelStatus(io.fabric8.kubernetes.api.builder.Predicate<SequenceChannelStatusBuilder> predicate){
            for (SequenceChannelStatusBuilder item: channelStatuses) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withChannelStatuses(List<SequenceChannelStatus> channelStatuses){
            if (this.channelStatuses != null) { _visitables.get("channelStatuses").removeAll(this.channelStatuses);}
            if (channelStatuses != null) {this.channelStatuses = new ArrayList<SequenceChannelStatusBuilder>(); for (SequenceChannelStatus item : channelStatuses){this.addToChannelStatuses(item);}} else { this.channelStatuses = null;} return (A) this;
    }

    public A withChannelStatuses(SequenceChannelStatus... channelStatuses){
            if (this.channelStatuses != null) {this.channelStatuses.clear();}
            if (channelStatuses != null) {for (SequenceChannelStatus item :channelStatuses){ this.addToChannelStatuses(item);}} return (A) this;
    }

    public Boolean hasChannelStatuses(){
            return channelStatuses != null && !channelStatuses.isEmpty();
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> addNewChannelStatus(){
            return new ChannelStatusesNestedImpl();
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> addNewChannelStatusLike(SequenceChannelStatus item){
            return new ChannelStatusesNestedImpl(-1, item);
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> setNewChannelStatusLike(int index,SequenceChannelStatus item){
            return new ChannelStatusesNestedImpl(index, item);
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> editChannelStatus(int index){
            if (channelStatuses.size() <= index) throw new RuntimeException("Can't edit channelStatuses. Index exceeds size.");
            return setNewChannelStatusLike(index, buildChannelStatus(index));
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> editFirstChannelStatus(){
            if (channelStatuses.size() == 0) throw new RuntimeException("Can't edit first channelStatuses. The list is empty.");
            return setNewChannelStatusLike(0, buildChannelStatus(0));
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> editLastChannelStatus(){
            int index = channelStatuses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last channelStatuses. The list is empty.");
            return setNewChannelStatusLike(index, buildChannelStatus(index));
    }

    public SequenceStatusFluent.ChannelStatusesNested<A> editMatchingChannelStatus(io.fabric8.kubernetes.api.builder.Predicate<SequenceChannelStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<channelStatuses.size();i++) { 
            if (predicate.apply(channelStatuses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching channelStatuses. No match found.");
            return setNewChannelStatusLike(index, buildChannelStatus(index));
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<ConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              ConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public SequenceStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public SequenceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public SequenceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public SequenceStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public SequenceStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public SequenceStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public SequenceStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public A addToSubscriptionStatuses(int index,SequenceSubscriptionStatus item){
            if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
            SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(index >= 0 ? index : _visitables.get("subscriptionStatuses").size(), builder);this.subscriptionStatuses.add(index >= 0 ? index : subscriptionStatuses.size(), builder); return (A)this;
    }

    public A setToSubscriptionStatuses(int index,SequenceSubscriptionStatus item){
            if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
            SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("subscriptionStatuses").size()) { _visitables.get("subscriptionStatuses").add(builder); } else { _visitables.get("subscriptionStatuses").set(index, builder);}
            if (index < 0 || index >= subscriptionStatuses.size()) { subscriptionStatuses.add(builder); } else { subscriptionStatuses.set(index, builder);}
             return (A)this;
    }

    public A addToSubscriptionStatuses(SequenceSubscriptionStatus... items){
            if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
            for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(builder);this.subscriptionStatuses.add(builder);} return (A)this;
    }

    public A addAllToSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items){
            if (this.subscriptionStatuses == null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>();}
            for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").add(builder);this.subscriptionStatuses.add(builder);} return (A)this;
    }

    public A removeFromSubscriptionStatuses(SequenceSubscriptionStatus... items){
            for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").remove(builder);if (this.subscriptionStatuses != null) {this.subscriptionStatuses.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscriptionStatuses(Collection<SequenceSubscriptionStatus> items){
            for (SequenceSubscriptionStatus item : items) {SequenceSubscriptionStatusBuilder builder = new SequenceSubscriptionStatusBuilder(item);_visitables.get("subscriptionStatuses").remove(builder);if (this.subscriptionStatuses != null) {this.subscriptionStatuses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscriptionStatuses(io.fabric8.kubernetes.api.builder.Predicate<SequenceSubscriptionStatusBuilder> predicate){
            if (subscriptionStatuses == null) return (A) this;
            final Iterator<SequenceSubscriptionStatusBuilder> each = subscriptionStatuses.iterator();
            final List visitables = _visitables.get("subscriptionStatuses");
            while (each.hasNext()) {
              SequenceSubscriptionStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscriptionStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<SequenceSubscriptionStatus> getSubscriptionStatuses(){
            return build(subscriptionStatuses);
    }

    public List<SequenceSubscriptionStatus> buildSubscriptionStatuses(){
            return build(subscriptionStatuses);
    }

    public SequenceSubscriptionStatus buildSubscriptionStatus(int index){
            return this.subscriptionStatuses.get(index).build();
    }

    public SequenceSubscriptionStatus buildFirstSubscriptionStatus(){
            return this.subscriptionStatuses.get(0).build();
    }

    public SequenceSubscriptionStatus buildLastSubscriptionStatus(){
            return this.subscriptionStatuses.get(subscriptionStatuses.size() - 1).build();
    }

    public SequenceSubscriptionStatus buildMatchingSubscriptionStatus(io.fabric8.kubernetes.api.builder.Predicate<SequenceSubscriptionStatusBuilder> predicate){
            for (SequenceSubscriptionStatusBuilder item: subscriptionStatuses) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriptionStatus(io.fabric8.kubernetes.api.builder.Predicate<SequenceSubscriptionStatusBuilder> predicate){
            for (SequenceSubscriptionStatusBuilder item: subscriptionStatuses) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubscriptionStatuses(List<SequenceSubscriptionStatus> subscriptionStatuses){
            if (this.subscriptionStatuses != null) { _visitables.get("subscriptionStatuses").removeAll(this.subscriptionStatuses);}
            if (subscriptionStatuses != null) {this.subscriptionStatuses = new ArrayList<SequenceSubscriptionStatusBuilder>(); for (SequenceSubscriptionStatus item : subscriptionStatuses){this.addToSubscriptionStatuses(item);}} else { this.subscriptionStatuses = null;} return (A) this;
    }

    public A withSubscriptionStatuses(SequenceSubscriptionStatus... subscriptionStatuses){
            if (this.subscriptionStatuses != null) {this.subscriptionStatuses.clear();}
            if (subscriptionStatuses != null) {for (SequenceSubscriptionStatus item :subscriptionStatuses){ this.addToSubscriptionStatuses(item);}} return (A) this;
    }

    public Boolean hasSubscriptionStatuses(){
            return subscriptionStatuses != null && !subscriptionStatuses.isEmpty();
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> addNewSubscriptionStatus(){
            return new SubscriptionStatusesNestedImpl();
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> addNewSubscriptionStatusLike(SequenceSubscriptionStatus item){
            return new SubscriptionStatusesNestedImpl(-1, item);
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> setNewSubscriptionStatusLike(int index,SequenceSubscriptionStatus item){
            return new SubscriptionStatusesNestedImpl(index, item);
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> editSubscriptionStatus(int index){
            if (subscriptionStatuses.size() <= index) throw new RuntimeException("Can't edit subscriptionStatuses. Index exceeds size.");
            return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> editFirstSubscriptionStatus(){
            if (subscriptionStatuses.size() == 0) throw new RuntimeException("Can't edit first subscriptionStatuses. The list is empty.");
            return setNewSubscriptionStatusLike(0, buildSubscriptionStatus(0));
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> editLastSubscriptionStatus(){
            int index = subscriptionStatuses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subscriptionStatuses. The list is empty.");
            return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
    }

    public SequenceStatusFluent.SubscriptionStatusesNested<A> editMatchingSubscriptionStatus(io.fabric8.kubernetes.api.builder.Predicate<SequenceSubscriptionStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<subscriptionStatuses.size();i++) { 
            if (predicate.apply(subscriptionStatuses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subscriptionStatuses. No match found.");
            return setNewSubscriptionStatusLike(index, buildSubscriptionStatus(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SequenceStatusFluentImpl that = (SequenceStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (channelStatuses != null ? !channelStatuses.equals(that.channelStatuses) :that.channelStatuses != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (subscriptionStatuses != null ? !subscriptionStatuses.equals(that.subscriptionStatuses) :that.subscriptionStatuses != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressableFluentImpl<SequenceStatusFluent.AddressNested<N>> implements SequenceStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AddressableBuilder builder;
    
            AddressNestedImpl(Addressable item){
                    this.builder = new AddressableBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressableBuilder(this);
            }
    
    public N and(){
            return (N) SequenceStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class ChannelStatusesNestedImpl<N> extends SequenceChannelStatusFluentImpl<SequenceStatusFluent.ChannelStatusesNested<N>> implements SequenceStatusFluent.ChannelStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SequenceChannelStatusBuilder builder;
        private final int index;
    
            ChannelStatusesNestedImpl(int index,SequenceChannelStatus item){
                    this.index = index;
                    this.builder = new SequenceChannelStatusBuilder(this, item);
            }
            ChannelStatusesNestedImpl(){
                    this.index = -1;
                    this.builder = new SequenceChannelStatusBuilder(this);
            }
    
    public N and(){
            return (N) SequenceStatusFluentImpl.this.setToChannelStatuses(index,builder.build());
    }
    public N endChannelStatus(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<SequenceStatusFluent.ConditionsNested<N>> implements SequenceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) SequenceStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class SubscriptionStatusesNestedImpl<N> extends SequenceSubscriptionStatusFluentImpl<SequenceStatusFluent.SubscriptionStatusesNested<N>> implements SequenceStatusFluent.SubscriptionStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SequenceSubscriptionStatusBuilder builder;
        private final int index;
    
            SubscriptionStatusesNestedImpl(int index,SequenceSubscriptionStatus item){
                    this.index = index;
                    this.builder = new SequenceSubscriptionStatusBuilder(this, item);
            }
            SubscriptionStatusesNestedImpl(){
                    this.index = -1;
                    this.builder = new SequenceSubscriptionStatusBuilder(this);
            }
    
    public N and(){
            return (N) SequenceStatusFluentImpl.this.setToSubscriptionStatuses(index,builder.build());
    }
    public N endSubscriptionStatus(){
            return and();
    }

}


}
