package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteSpecBuilder extends io.fabric8.knative.serving.v1.RouteSpecFluentImpl<io.fabric8.knative.serving.v1.RouteSpecBuilder> implements VisitableBuilder<io.fabric8.knative.serving.v1.RouteSpec,io.fabric8.knative.serving.v1.RouteSpecBuilder>{

    io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RouteSpecBuilder(){
            this(true);
    }
    public RouteSpecBuilder(Boolean validationEnabled){
            this(new RouteSpec(), validationEnabled);
    }
    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteSpec(), validationEnabled);
    }
    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent,io.fabric8.knative.serving.v1.RouteSpec instance){
            this(fluent, instance, true);
    }
    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpecFluent<?> fluent,io.fabric8.knative.serving.v1.RouteSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTraffic(instance.getTraffic()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpec instance){
            this(instance,true);
    }
    public RouteSpecBuilder(io.fabric8.knative.serving.v1.RouteSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTraffic(instance.getTraffic()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.RouteSpec build(){
            RouteSpec buildable = new RouteSpec(fluent.getTraffic());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteSpecBuilder that = (RouteSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
