package io.fabric8.knative.serving.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TrafficTargetFluentImpl<A extends io.fabric8.knative.serving.v1.TrafficTargetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1.TrafficTargetFluent<A>{

    private String configurationName;
    private Boolean latestRevision;
    private Long percent;
    private String revisionName;
    private String tag;
    private String url;

    public TrafficTargetFluentImpl(){
    }
    public TrafficTargetFluentImpl(io.fabric8.knative.serving.v1.TrafficTarget instance){
            this.withConfigurationName(instance.getConfigurationName()); 
            this.withLatestRevision(instance.getLatestRevision()); 
            this.withPercent(instance.getPercent()); 
            this.withRevisionName(instance.getRevisionName()); 
            this.withTag(instance.getTag()); 
            this.withUrl(instance.getUrl()); 
    }

    public String getConfigurationName(){
            return this.configurationName;
    }

    public A withConfigurationName(String configurationName){
            this.configurationName=configurationName; return (A) this;
    }

    public Boolean hasConfigurationName(){
            return this.configurationName != null;
    }

    public A withNewConfigurationName(String arg1){
            return (A)withConfigurationName(new String(arg1));
    }

    public A withNewConfigurationName(StringBuilder arg1){
            return (A)withConfigurationName(new String(arg1));
    }

    public A withNewConfigurationName(StringBuffer arg1){
            return (A)withConfigurationName(new String(arg1));
    }

    public Boolean isLatestRevision(){
            return this.latestRevision;
    }

    public A withLatestRevision(Boolean latestRevision){
            this.latestRevision=latestRevision; return (A) this;
    }

    public Boolean hasLatestRevision(){
            return this.latestRevision != null;
    }

    public A withNewLatestRevision(String arg1){
            return (A)withLatestRevision(new Boolean(arg1));
    }

    public A withNewLatestRevision(boolean arg1){
            return (A)withLatestRevision(new Boolean(arg1));
    }

    public Long getPercent(){
            return this.percent;
    }

    public A withPercent(Long percent){
            this.percent=percent; return (A) this;
    }

    public Boolean hasPercent(){
            return this.percent != null;
    }

    public String getRevisionName(){
            return this.revisionName;
    }

    public A withRevisionName(String revisionName){
            this.revisionName=revisionName; return (A) this;
    }

    public Boolean hasRevisionName(){
            return this.revisionName != null;
    }

    public A withNewRevisionName(String arg1){
            return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuilder arg1){
            return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuffer arg1){
            return (A)withRevisionName(new String(arg1));
    }

    public String getTag(){
            return this.tag;
    }

    public A withTag(String tag){
            this.tag=tag; return (A) this;
    }

    public Boolean hasTag(){
            return this.tag != null;
    }

    public A withNewTag(String arg1){
            return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuilder arg1){
            return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1){
            return (A)withTag(new String(arg1));
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TrafficTargetFluentImpl that = (TrafficTargetFluentImpl) o;
            if (configurationName != null ? !configurationName.equals(that.configurationName) :that.configurationName != null) return false;
            if (latestRevision != null ? !latestRevision.equals(that.latestRevision) :that.latestRevision != null) return false;
            if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
            if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
            if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }




}
