package io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableStatusBuilder extends SubscribableStatusFluentImpl<SubscribableStatusBuilder> implements VisitableBuilder<SubscribableStatus,SubscribableStatusBuilder>{

    SubscribableStatusFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableStatusBuilder(){
            this(true);
    }
    public SubscribableStatusBuilder(Boolean validationEnabled){
            this(new SubscribableStatus(), validationEnabled);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableStatus(), validationEnabled);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,SubscribableStatus instance){
            this(fluent, instance, true);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,SubscribableStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableStatusBuilder(SubscribableStatus instance){
            this(instance,true);
    }
    public SubscribableStatusBuilder(SubscribableStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscribableStatus build(){
            SubscribableStatus buildable = new SubscribableStatus(fluent.getSubscribers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableStatusBuilder that = (SubscribableStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
