package io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1;

import io.fabric8.knative.serving.v1.ConfigurationBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.serving.v1.Configuration;
import io.fabric8.knative.eventing.v1alpha1.EventType;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelFluentImpl;
import java.lang.String;
import io.fabric8.knative.eventing.v1alpha1.EventTypeFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.Trigger;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.messaging.v1alpha1.Subscription;
import java.lang.Boolean;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.knative.serving.v1.RouteFluentImpl;
import io.fabric8.knative.serving.v1.ConfigurationFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.knative.serving.v1.RevisionFluentImpl;
import io.fabric8.knative.messaging.v1alpha1.Channel;
import io.fabric8.knative.flows.v1alpha1.Sequence;
import io.fabric8.knative.messaging.v1alpha1.SubscriptionBuilder;
import io.fabric8.knative.eventing.v1alpha1.BrokerFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.TriggerBuilder;
import io.fabric8.knative.serving.v1.Revision;
import java.lang.Object;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannel;
import io.fabric8.knative.flows.v1alpha1.SequenceFluentImpl;
import io.fabric8.knative.serving.v1.RouteBuilder;
import java.lang.StringBuilder;
import io.fabric8.knative.flows.v1alpha1.SequenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelBuilder;
import io.fabric8.knative.serving.v1.ServiceBuilder;
import java.lang.Deprecated;
import io.fabric8.knative.messaging.v1alpha1.ChannelBuilder;
import io.fabric8.knative.messaging.v1alpha1.SubscriptionFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.Broker;
import io.fabric8.knative.eventing.v1alpha1.BrokerBuilder;
import io.fabric8.knative.eventing.v1alpha1.EventTypeBuilder;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.knative.eventing.v1alpha1.TriggerFluentImpl;
import io.fabric8.knative.messaging.v1alpha1.ChannelFluentImpl;
import io.fabric8.knative.serving.v1.RevisionBuilder;
import java.lang.StringBuffer;
import io.fabric8.knative.serving.v1.ServiceFluentImpl;

public class ChannelTemplateSpecFluentImpl<A extends ChannelTemplateSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelTemplateSpecFluent<A>{

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends HasMetadata,?> spec;

    public ChannelTemplateSpecFluentImpl(){
    }
    public ChannelTemplateSpecFluentImpl(ChannelTemplateSpec instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withSpec(instance.getSpec()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public HasMetadata buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(HasMetadata spec){
            if (spec instanceof io.fabric8.knative.serving.v1beta1.Revision){ this.spec= new io.fabric8.knative.serving.v1beta1.RevisionBuilder((io.fabric8.knative.serving.v1beta1.Revision)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Revision){ this.spec= new RevisionBuilder((Revision)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Subscription){ this.spec= new SubscriptionBuilder((Subscription)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof InMemoryChannel){ this.spec= new InMemoryChannelBuilder((InMemoryChannel)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Sequence){ this.spec= new SequenceBuilder((Sequence)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Service){ this.spec= new ServiceBuilder((Service)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof io.fabric8.knative.serving.v1beta1.Service){ this.spec= new io.fabric8.knative.serving.v1beta1.ServiceBuilder((io.fabric8.knative.serving.v1beta1.Service)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof io.fabric8.knative.serving.v1beta1.Route){ this.spec= new io.fabric8.knative.serving.v1beta1.RouteBuilder((io.fabric8.knative.serving.v1beta1.Route)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Trigger){ this.spec= new TriggerBuilder((Trigger)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Configuration){ this.spec= new ConfigurationBuilder((Configuration)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof io.fabric8.knative.serving.v1beta1.Configuration){ this.spec= new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder((io.fabric8.knative.serving.v1beta1.Configuration)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Broker){ this.spec= new BrokerBuilder((Broker)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Route){ this.spec= new RouteBuilder((Route)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof EventType){ this.spec= new EventTypeBuilder((EventType)spec); _visitables.get("spec").add(this.spec);}
            if (spec instanceof Channel){ this.spec= new ChannelBuilder((Channel)spec); _visitables.get("spec").add(this.spec);}
            return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public A withRevisionSpec(io.fabric8.knative.serving.v1beta1.Revision revisionSpec){
            _visitables.get("spec").remove(this.spec);
            if (revisionSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.RevisionBuilder(revisionSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<A> withNewV1beta1RevisionSpec(){
            return new V1beta1RevisionSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<A> withNewRevisionSpecLike(io.fabric8.knative.serving.v1beta1.Revision item){
            return new V1beta1RevisionSpecNestedImpl(item);
    }

    public A withRevisionSpec(Revision revisionSpec){
            _visitables.get("spec").remove(this.spec);
            if (revisionSpec!=null){ this.spec= new RevisionBuilder(revisionSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.RevisionSpecNested<A> withNewRevisionSpec(){
            return new RevisionSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.RevisionSpecNested<A> withNewRevisionSpecLike(Revision item){
            return new RevisionSpecNestedImpl(item);
    }

    public A withSubscriptionSpec(Subscription subscriptionSpec){
            _visitables.get("spec").remove(this.spec);
            if (subscriptionSpec!=null){ this.spec= new SubscriptionBuilder(subscriptionSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.SubscriptionSpecNested<A> withNewSubscriptionSpec(){
            return new SubscriptionSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.SubscriptionSpecNested<A> withNewSubscriptionSpecLike(Subscription item){
            return new SubscriptionSpecNestedImpl(item);
    }

    public A withInMemoryChannelSpec(InMemoryChannel inMemoryChannelSpec){
            _visitables.get("spec").remove(this.spec);
            if (inMemoryChannelSpec!=null){ this.spec= new InMemoryChannelBuilder(inMemoryChannelSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.InMemoryChannelSpecNested<A> withNewInMemoryChannelSpec(){
            return new InMemoryChannelSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.InMemoryChannelSpecNested<A> withNewInMemoryChannelSpecLike(InMemoryChannel item){
            return new InMemoryChannelSpecNestedImpl(item);
    }

    public A withSequenceSpec(Sequence sequenceSpec){
            _visitables.get("spec").remove(this.spec);
            if (sequenceSpec!=null){ this.spec= new SequenceBuilder(sequenceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.SequenceSpecNested<A> withNewSequenceSpec(){
            return new SequenceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.SequenceSpecNested<A> withNewSequenceSpecLike(Sequence item){
            return new SequenceSpecNestedImpl(item);
    }

    public A withServiceSpec(Service serviceSpec){
            _visitables.get("spec").remove(this.spec);
            if (serviceSpec!=null){ this.spec= new ServiceBuilder(serviceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ServiceSpecNested<A> withNewServiceSpec(){
            return new ServiceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ServiceSpecNested<A> withNewServiceSpecLike(Service item){
            return new ServiceSpecNestedImpl(item);
    }

    public A withServiceSpec(io.fabric8.knative.serving.v1beta1.Service serviceSpec){
            _visitables.get("spec").remove(this.spec);
            if (serviceSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.ServiceBuilder(serviceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<A> withNewV1beta1ServiceSpec(){
            return new V1beta1ServiceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<A> withNewServiceSpecLike(io.fabric8.knative.serving.v1beta1.Service item){
            return new V1beta1ServiceSpecNestedImpl(item);
    }

    public A withRouteSpec(io.fabric8.knative.serving.v1beta1.Route routeSpec){
            _visitables.get("spec").remove(this.spec);
            if (routeSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.RouteBuilder(routeSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1RouteSpecNested<A> withNewV1beta1RouteSpec(){
            return new V1beta1RouteSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1RouteSpecNested<A> withNewRouteSpecLike(io.fabric8.knative.serving.v1beta1.Route item){
            return new V1beta1RouteSpecNestedImpl(item);
    }

    public A withTriggerSpec(Trigger triggerSpec){
            _visitables.get("spec").remove(this.spec);
            if (triggerSpec!=null){ this.spec= new TriggerBuilder(triggerSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.TriggerSpecNested<A> withNewTriggerSpec(){
            return new TriggerSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.TriggerSpecNested<A> withNewTriggerSpecLike(Trigger item){
            return new TriggerSpecNestedImpl(item);
    }

    public A withConfigurationSpec(Configuration configurationSpec){
            _visitables.get("spec").remove(this.spec);
            if (configurationSpec!=null){ this.spec= new ConfigurationBuilder(configurationSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ConfigurationSpecNested<A> withNewConfigurationSpec(){
            return new ConfigurationSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ConfigurationSpecNested<A> withNewConfigurationSpecLike(Configuration item){
            return new ConfigurationSpecNestedImpl(item);
    }

    public A withConfigurationSpec(io.fabric8.knative.serving.v1beta1.Configuration configurationSpec){
            _visitables.get("spec").remove(this.spec);
            if (configurationSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder(configurationSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<A> withNewV1beta1ConfigurationSpec(){
            return new V1beta1ConfigurationSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<A> withNewConfigurationSpecLike(io.fabric8.knative.serving.v1beta1.Configuration item){
            return new V1beta1ConfigurationSpecNestedImpl(item);
    }

    public A withBrokerSpec(Broker brokerSpec){
            _visitables.get("spec").remove(this.spec);
            if (brokerSpec!=null){ this.spec= new BrokerBuilder(brokerSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.BrokerSpecNested<A> withNewBrokerSpec(){
            return new BrokerSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.BrokerSpecNested<A> withNewBrokerSpecLike(Broker item){
            return new BrokerSpecNestedImpl(item);
    }

    public A withRouteSpec(Route routeSpec){
            _visitables.get("spec").remove(this.spec);
            if (routeSpec!=null){ this.spec= new RouteBuilder(routeSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.RouteSpecNested<A> withNewRouteSpec(){
            return new RouteSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.RouteSpecNested<A> withNewRouteSpecLike(Route item){
            return new RouteSpecNestedImpl(item);
    }

    public A withEventTypeSpec(EventType eventTypeSpec){
            _visitables.get("spec").remove(this.spec);
            if (eventTypeSpec!=null){ this.spec= new EventTypeBuilder(eventTypeSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.EventTypeSpecNested<A> withNewEventTypeSpec(){
            return new EventTypeSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.EventTypeSpecNested<A> withNewEventTypeSpecLike(EventType item){
            return new EventTypeSpecNestedImpl(item);
    }

    public A withChannelSpec(Channel channelSpec){
            _visitables.get("spec").remove(this.spec);
            if (channelSpec!=null){ this.spec= new ChannelBuilder(channelSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ChannelSpecNested<A> withNewChannelSpec(){
            return new ChannelSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ChannelSpecNested<A> withNewChannelSpecLike(Channel item){
            return new ChannelSpecNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelTemplateSpecFluentImpl that = (ChannelTemplateSpecFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class V1beta1RevisionSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.RevisionFluentImpl<ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1beta1.RevisionBuilder builder;
    
            V1beta1RevisionSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Revision item){
                    this.builder = new io.fabric8.knative.serving.v1beta1.RevisionBuilder(this, item);
            }
            V1beta1RevisionSpecNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1beta1.RevisionBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endV1beta1RevisionSpec(){
            return and();
    }

}
    public class RevisionSpecNestedImpl<N> extends RevisionFluentImpl<ChannelTemplateSpecFluent.RevisionSpecNested<N>> implements ChannelTemplateSpecFluent.RevisionSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RevisionBuilder builder;
    
            RevisionSpecNestedImpl(Revision item){
                    this.builder = new RevisionBuilder(this, item);
            }
            RevisionSpecNestedImpl(){
                    this.builder = new RevisionBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endRevisionSpec(){
            return and();
    }

}
    public class SubscriptionSpecNestedImpl<N> extends SubscriptionFluentImpl<ChannelTemplateSpecFluent.SubscriptionSpecNested<N>> implements ChannelTemplateSpecFluent.SubscriptionSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriptionBuilder builder;
    
            SubscriptionSpecNestedImpl(Subscription item){
                    this.builder = new SubscriptionBuilder(this, item);
            }
            SubscriptionSpecNestedImpl(){
                    this.builder = new SubscriptionBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endSubscriptionSpec(){
            return and();
    }

}
    public class InMemoryChannelSpecNestedImpl<N> extends InMemoryChannelFluentImpl<ChannelTemplateSpecFluent.InMemoryChannelSpecNested<N>> implements ChannelTemplateSpecFluent.InMemoryChannelSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InMemoryChannelBuilder builder;
    
            InMemoryChannelSpecNestedImpl(InMemoryChannel item){
                    this.builder = new InMemoryChannelBuilder(this, item);
            }
            InMemoryChannelSpecNestedImpl(){
                    this.builder = new InMemoryChannelBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endInMemoryChannelSpec(){
            return and();
    }

}
    public class SequenceSpecNestedImpl<N> extends SequenceFluentImpl<ChannelTemplateSpecFluent.SequenceSpecNested<N>> implements ChannelTemplateSpecFluent.SequenceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SequenceBuilder builder;
    
            SequenceSpecNestedImpl(Sequence item){
                    this.builder = new SequenceBuilder(this, item);
            }
            SequenceSpecNestedImpl(){
                    this.builder = new SequenceBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endSequenceSpec(){
            return and();
    }

}
    public class ServiceSpecNestedImpl<N> extends ServiceFluentImpl<ChannelTemplateSpecFluent.ServiceSpecNested<N>> implements ChannelTemplateSpecFluent.ServiceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceBuilder builder;
    
            ServiceSpecNestedImpl(Service item){
                    this.builder = new ServiceBuilder(this, item);
            }
            ServiceSpecNestedImpl(){
                    this.builder = new ServiceBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endServiceSpec(){
            return and();
    }

}
    public class V1beta1ServiceSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.ServiceFluentImpl<ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1beta1.ServiceBuilder builder;
    
            V1beta1ServiceSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Service item){
                    this.builder = new io.fabric8.knative.serving.v1beta1.ServiceBuilder(this, item);
            }
            V1beta1ServiceSpecNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1beta1.ServiceBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endV1beta1ServiceSpec(){
            return and();
    }

}
    public class V1beta1RouteSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.RouteFluentImpl<ChannelTemplateSpecFluent.V1beta1RouteSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1RouteSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1beta1.RouteBuilder builder;
    
            V1beta1RouteSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Route item){
                    this.builder = new io.fabric8.knative.serving.v1beta1.RouteBuilder(this, item);
            }
            V1beta1RouteSpecNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1beta1.RouteBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endV1beta1RouteSpec(){
            return and();
    }

}
    public class TriggerSpecNestedImpl<N> extends TriggerFluentImpl<ChannelTemplateSpecFluent.TriggerSpecNested<N>> implements ChannelTemplateSpecFluent.TriggerSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TriggerBuilder builder;
    
            TriggerSpecNestedImpl(Trigger item){
                    this.builder = new TriggerBuilder(this, item);
            }
            TriggerSpecNestedImpl(){
                    this.builder = new TriggerBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endTriggerSpec(){
            return and();
    }

}
    public class ConfigurationSpecNestedImpl<N> extends ConfigurationFluentImpl<ChannelTemplateSpecFluent.ConfigurationSpecNested<N>> implements ChannelTemplateSpecFluent.ConfigurationSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigurationBuilder builder;
    
            ConfigurationSpecNestedImpl(Configuration item){
                    this.builder = new ConfigurationBuilder(this, item);
            }
            ConfigurationSpecNestedImpl(){
                    this.builder = new ConfigurationBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endConfigurationSpec(){
            return and();
    }

}
    public class V1beta1ConfigurationSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.ConfigurationFluentImpl<ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1beta1.ConfigurationBuilder builder;
    
            V1beta1ConfigurationSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Configuration item){
                    this.builder = new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder(this, item);
            }
            V1beta1ConfigurationSpecNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endV1beta1ConfigurationSpec(){
            return and();
    }

}
    public class BrokerSpecNestedImpl<N> extends BrokerFluentImpl<ChannelTemplateSpecFluent.BrokerSpecNested<N>> implements ChannelTemplateSpecFluent.BrokerSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BrokerBuilder builder;
    
            BrokerSpecNestedImpl(Broker item){
                    this.builder = new BrokerBuilder(this, item);
            }
            BrokerSpecNestedImpl(){
                    this.builder = new BrokerBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endBrokerSpec(){
            return and();
    }

}
    public class RouteSpecNestedImpl<N> extends RouteFluentImpl<ChannelTemplateSpecFluent.RouteSpecNested<N>> implements ChannelTemplateSpecFluent.RouteSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
    
            RouteSpecNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
            RouteSpecNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endRouteSpec(){
            return and();
    }

}
    public class EventTypeSpecNestedImpl<N> extends EventTypeFluentImpl<ChannelTemplateSpecFluent.EventTypeSpecNested<N>> implements ChannelTemplateSpecFluent.EventTypeSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EventTypeBuilder builder;
    
            EventTypeSpecNestedImpl(EventType item){
                    this.builder = new EventTypeBuilder(this, item);
            }
            EventTypeSpecNestedImpl(){
                    this.builder = new EventTypeBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endEventTypeSpec(){
            return and();
    }

}
    public class ChannelSpecNestedImpl<N> extends ChannelFluentImpl<ChannelTemplateSpecFluent.ChannelSpecNested<N>> implements ChannelTemplateSpecFluent.ChannelSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelBuilder builder;
    
            ChannelSpecNestedImpl(Channel item){
                    this.builder = new ChannelBuilder(this, item);
            }
            ChannelSpecNestedImpl(){
                    this.builder = new ChannelBuilder(this);
            }
    
    public N and(){
            return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
    }
    public N endChannelSpec(){
            return and();
    }

}


}
