package io.fabric8.knative.internal.pkg.apis.duck.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AddressableFluentImpl<A extends AddressableFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AddressableFluent<A>{

    private String url;

    public AddressableFluentImpl(){
    }
    public AddressableFluentImpl(Addressable instance){
            this.withUrl(instance.getUrl()); 
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AddressableFluentImpl that = (AddressableFluentImpl) o;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }




}
