package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SubscriptionListFluent<A extends SubscriptionListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Subscription item);
    public A setToItems(int index,Subscription item);
    public A addToItems(Subscription... items);
    public A addAllToItems(Collection<Subscription> items);
    public A removeFromItems(Subscription... items);
    public A removeAllFromItems(Collection<Subscription> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<SubscriptionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Subscription> getItems();
    public List<Subscription> buildItems();
    public Subscription buildItem(int index);
    public Subscription buildFirstItem();
    public Subscription buildLastItem();
    public Subscription buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SubscriptionBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SubscriptionBuilder> predicate);
    public A withItems(List<Subscription> items);
    public A withItems(Subscription... items);
    public Boolean hasItems();
    public SubscriptionListFluent.ItemsNested<A> addNewItem();
    public SubscriptionListFluent.ItemsNested<A> addNewItemLike(Subscription item);
    public SubscriptionListFluent.ItemsNested<A> setNewItemLike(int index,Subscription item);
    public SubscriptionListFluent.ItemsNested<A> editItem(int index);
    public SubscriptionListFluent.ItemsNested<A> editFirstItem();
    public SubscriptionListFluent.ItemsNested<A> editLastItem();
    public SubscriptionListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SubscriptionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SubscriptionFluent<SubscriptionListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
