package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class RevisionStatusFluentImpl<A extends io.fabric8.knative.serving.v1.RevisionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1.RevisionStatusFluent<A>{

    private List<ConditionBuilder> conditions;
    private String imageDigest;
    private String logUrl;
    private Long observedGeneration;
    private String serviceName;

    public RevisionStatusFluentImpl(){
    }
    public RevisionStatusFluentImpl(io.fabric8.knative.serving.v1.RevisionStatus instance){
            this.withConditions(instance.getConditions()); 
            this.withImageDigest(instance.getImageDigest()); 
            this.withLogUrl(instance.getLogUrl()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withServiceName(instance.getServiceName()); 
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<ConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              ConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public RevisionStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public RevisionStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public RevisionStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public RevisionStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public String getImageDigest(){
            return this.imageDigest;
    }

    public A withImageDigest(String imageDigest){
            this.imageDigest=imageDigest; return (A) this;
    }

    public Boolean hasImageDigest(){
            return this.imageDigest != null;
    }

    public A withNewImageDigest(String arg1){
            return (A)withImageDigest(new String(arg1));
    }

    public A withNewImageDigest(StringBuilder arg1){
            return (A)withImageDigest(new String(arg1));
    }

    public A withNewImageDigest(StringBuffer arg1){
            return (A)withImageDigest(new String(arg1));
    }

    public String getLogUrl(){
            return this.logUrl;
    }

    public A withLogUrl(String logUrl){
            this.logUrl=logUrl; return (A) this;
    }

    public Boolean hasLogUrl(){
            return this.logUrl != null;
    }

    public A withNewLogUrl(String arg1){
            return (A)withLogUrl(new String(arg1));
    }

    public A withNewLogUrl(StringBuilder arg1){
            return (A)withLogUrl(new String(arg1));
    }

    public A withNewLogUrl(StringBuffer arg1){
            return (A)withLogUrl(new String(arg1));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName(){
            return this.serviceName != null;
    }

    public A withNewServiceName(String arg1){
            return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuilder arg1){
            return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuffer arg1){
            return (A)withServiceName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RevisionStatusFluentImpl that = (RevisionStatusFluentImpl) o;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (imageDigest != null ? !imageDigest.equals(that.imageDigest) :that.imageDigest != null) return false;
            if (logUrl != null ? !logUrl.equals(that.logUrl) :that.logUrl != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<RevisionStatusFluent.ConditionsNested<N>> implements RevisionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) RevisionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
