package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RevisionListFluent<A extends RevisionListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Revision item);
    public A setToItems(int index,Revision item);
    public A addToItems(Revision... items);
    public A addAllToItems(Collection<Revision> items);
    public A removeFromItems(Revision... items);
    public A removeAllFromItems(Collection<Revision> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<RevisionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Revision> getItems();
    public List<Revision> buildItems();
    public Revision buildItem(int index);
    public Revision buildFirstItem();
    public Revision buildLastItem();
    public Revision buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<RevisionBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<RevisionBuilder> predicate);
    public A withItems(List<Revision> items);
    public A withItems(Revision... items);
    public Boolean hasItems();
    public RevisionListFluent.ItemsNested<A> addNewItem();
    public RevisionListFluent.ItemsNested<A> addNewItemLike(Revision item);
    public RevisionListFluent.ItemsNested<A> setNewItemLike(int index,Revision item);
    public RevisionListFluent.ItemsNested<A> editItem(int index);
    public RevisionListFluent.ItemsNested<A> editFirstItem();
    public RevisionListFluent.ItemsNested<A> editLastItem();
    public RevisionListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<RevisionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RevisionFluent<RevisionListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
