package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InMemoryChannelStatusBuilder extends InMemoryChannelStatusFluentImpl<InMemoryChannelStatusBuilder> implements VisitableBuilder<InMemoryChannelStatus,InMemoryChannelStatusBuilder>{

    InMemoryChannelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public InMemoryChannelStatusBuilder(){
            this(true);
    }
    public InMemoryChannelStatusBuilder(Boolean validationEnabled){
            this(new InMemoryChannelStatus(), validationEnabled);
    }
    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent){
            this(fluent, true);
    }
    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new InMemoryChannelStatus(), validationEnabled);
    }
    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance){
            this(fluent, instance, true);
    }
    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscribableStatus(instance.getSubscribableStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance){
            this(instance,true);
    }
    public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribableStatus(instance.getSubscribableStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public InMemoryChannelStatus build(){
            InMemoryChannelStatus buildable = new InMemoryChannelStatus(fluent.getAddress(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSubscribableStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InMemoryChannelStatusBuilder that = (InMemoryChannelStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
