package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ConfigurationFluent<A extends ConfigurationFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ConfigurationFluent.MetadataNested<A> withNewMetadata();
    public ConfigurationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ConfigurationFluent.MetadataNested<A> editMetadata();
    public ConfigurationFluent.MetadataNested<A> editOrNewMetadata();
    public ConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.serving.v1.ConfigurationSpec getSpec();
    public io.fabric8.knative.serving.v1.ConfigurationSpec buildSpec();
    public A withSpec(io.fabric8.knative.serving.v1.ConfigurationSpec spec);
    public Boolean hasSpec();
    public ConfigurationFluent.SpecNested<A> withNewSpec();
    public ConfigurationFluent.SpecNested<A> withNewSpecLike(io.fabric8.knative.serving.v1.ConfigurationSpec item);
    public ConfigurationFluent.SpecNested<A> editSpec();
    public ConfigurationFluent.SpecNested<A> editOrNewSpec();
    public ConfigurationFluent.SpecNested<A> editOrNewSpecLike(io.fabric8.knative.serving.v1.ConfigurationSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.serving.v1.ConfigurationStatus getStatus();
    public io.fabric8.knative.serving.v1.ConfigurationStatus buildStatus();
    public A withStatus(io.fabric8.knative.serving.v1.ConfigurationStatus status);
    public Boolean hasStatus();
    public ConfigurationFluent.StatusNested<A> withNewStatus();
    public ConfigurationFluent.StatusNested<A> withNewStatusLike(io.fabric8.knative.serving.v1.ConfigurationStatus item);
    public ConfigurationFluent.StatusNested<A> editStatus();
    public ConfigurationFluent.StatusNested<A> editOrNewStatus();
    public ConfigurationFluent.StatusNested<A> editOrNewStatusLike(io.fabric8.knative.serving.v1.ConfigurationStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ConfigurationFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.serving.v1.ConfigurationSpecFluent<ConfigurationFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.serving.v1.ConfigurationStatusFluent<ConfigurationFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
