package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TrafficTargetBuilder extends io.fabric8.knative.serving.v1.TrafficTargetFluentImpl<io.fabric8.knative.serving.v1.TrafficTargetBuilder> implements VisitableBuilder<io.fabric8.knative.serving.v1.TrafficTarget,io.fabric8.knative.serving.v1.TrafficTargetBuilder>{

    io.fabric8.knative.serving.v1.TrafficTargetFluent<?> fluent;
    Boolean validationEnabled;

    public TrafficTargetBuilder(){
            this(true);
    }
    public TrafficTargetBuilder(Boolean validationEnabled){
            this(new TrafficTarget(), validationEnabled);
    }
    public TrafficTargetBuilder(io.fabric8.knative.serving.v1.TrafficTargetFluent<?> fluent){
            this(fluent, true);
    }
    public TrafficTargetBuilder(io.fabric8.knative.serving.v1.TrafficTargetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TrafficTarget(), validationEnabled);
    }
    public TrafficTargetBuilder(io.fabric8.knative.serving.v1.TrafficTargetFluent<?> fluent,io.fabric8.knative.serving.v1.TrafficTarget instance){
            this(fluent, instance, true);
    }
    public TrafficTargetBuilder(io.fabric8.knative.serving.v1.TrafficTargetFluent<?> fluent,io.fabric8.knative.serving.v1.TrafficTarget instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfigurationName(instance.getConfigurationName()); 
            fluent.withLatestRevision(instance.getLatestRevision()); 
            fluent.withPercent(instance.getPercent()); 
            fluent.withRevisionName(instance.getRevisionName()); 
            fluent.withTag(instance.getTag()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public TrafficTargetBuilder(io.fabric8.knative.serving.v1.TrafficTarget instance){
            this(instance,true);
    }
    public TrafficTargetBuilder(io.fabric8.knative.serving.v1.TrafficTarget instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfigurationName(instance.getConfigurationName()); 
            this.withLatestRevision(instance.getLatestRevision()); 
            this.withPercent(instance.getPercent()); 
            this.withRevisionName(instance.getRevisionName()); 
            this.withTag(instance.getTag()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.TrafficTarget build(){
            TrafficTarget buildable = new TrafficTarget(fluent.getConfigurationName(),fluent.isLatestRevision(),fluent.getPercent(),fluent.getRevisionName(),fluent.getTag(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TrafficTargetBuilder that = (TrafficTargetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
