package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1.ChannelTemplateSpec;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpec;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpecBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import java.lang.Object;

public class BrokerSpecFluentImpl<A extends BrokerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BrokerSpecFluent<A>{

    private ChannelTemplateSpecBuilder channelTemplateSpec;
    private KReferenceBuilder config;
    private DeliverySpecBuilder delivery;

    public BrokerSpecFluentImpl(){
    }
    public BrokerSpecFluentImpl(BrokerSpec instance){
            this.withChannelTemplateSpec(instance.getChannelTemplateSpec()); 
            this.withConfig(instance.getConfig()); 
            this.withDelivery(instance.getDelivery()); 
    }

    
/**
 * This method has been deprecated, please use method buildChannelTemplateSpec instead.
 * @return The buildable object.
 */
@Deprecated public ChannelTemplateSpec getChannelTemplateSpec(){
            return this.channelTemplateSpec!=null?this.channelTemplateSpec.build():null;
    }

    public ChannelTemplateSpec buildChannelTemplateSpec(){
            return this.channelTemplateSpec!=null?this.channelTemplateSpec.build():null;
    }

    public A withChannelTemplateSpec(ChannelTemplateSpec channelTemplateSpec){
            _visitables.get("channelTemplateSpec").remove(this.channelTemplateSpec);
            if (channelTemplateSpec!=null){ this.channelTemplateSpec= new ChannelTemplateSpecBuilder(channelTemplateSpec); _visitables.get("channelTemplateSpec").add(this.channelTemplateSpec);} return (A) this;
    }

    public Boolean hasChannelTemplateSpec(){
            return this.channelTemplateSpec != null;
    }

    public BrokerSpecFluent.ChannelTemplateSpecNested<A> withNewChannelTemplateSpec(){
            return new ChannelTemplateSpecNestedImpl();
    }

    public BrokerSpecFluent.ChannelTemplateSpecNested<A> withNewChannelTemplateSpecLike(ChannelTemplateSpec item){
            return new ChannelTemplateSpecNestedImpl(item);
    }

    public BrokerSpecFluent.ChannelTemplateSpecNested<A> editChannelTemplateSpec(){
            return withNewChannelTemplateSpecLike(getChannelTemplateSpec());
    }

    public BrokerSpecFluent.ChannelTemplateSpecNested<A> editOrNewChannelTemplateSpec(){
            return withNewChannelTemplateSpecLike(getChannelTemplateSpec() != null ? getChannelTemplateSpec(): new ChannelTemplateSpecBuilder().build());
    }

    public BrokerSpecFluent.ChannelTemplateSpecNested<A> editOrNewChannelTemplateSpecLike(ChannelTemplateSpec item){
            return withNewChannelTemplateSpecLike(getChannelTemplateSpec() != null ? getChannelTemplateSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfig instead.
 * @return The buildable object.
 */
@Deprecated public KReference getConfig(){
            return this.config!=null?this.config.build():null;
    }

    public KReference buildConfig(){
            return this.config!=null?this.config.build():null;
    }

    public A withConfig(KReference config){
            _visitables.get("config").remove(this.config);
            if (config!=null){ this.config= new KReferenceBuilder(config); _visitables.get("config").add(this.config);} return (A) this;
    }

    public Boolean hasConfig(){
            return this.config != null;
    }

    public A withNewConfig(String apiVersion,String kind,String name,String namespace){
            return (A)withConfig(new KReference(apiVersion, kind, name, namespace));
    }

    public BrokerSpecFluent.ConfigNested<A> withNewConfig(){
            return new ConfigNestedImpl();
    }

    public BrokerSpecFluent.ConfigNested<A> withNewConfigLike(KReference item){
            return new ConfigNestedImpl(item);
    }

    public BrokerSpecFluent.ConfigNested<A> editConfig(){
            return withNewConfigLike(getConfig());
    }

    public BrokerSpecFluent.ConfigNested<A> editOrNewConfig(){
            return withNewConfigLike(getConfig() != null ? getConfig(): new KReferenceBuilder().build());
    }

    public BrokerSpecFluent.ConfigNested<A> editOrNewConfigLike(KReference item){
            return withNewConfigLike(getConfig() != null ? getConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery){
            _visitables.get("delivery").remove(this.delivery);
            if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery(){
            return this.delivery != null;
    }

    public BrokerSpecFluent.DeliveryNested<A> withNewDelivery(){
            return new DeliveryNestedImpl();
    }

    public BrokerSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item){
            return new DeliveryNestedImpl(item);
    }

    public BrokerSpecFluent.DeliveryNested<A> editDelivery(){
            return withNewDeliveryLike(getDelivery());
    }

    public BrokerSpecFluent.DeliveryNested<A> editOrNewDelivery(){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public BrokerSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            BrokerSpecFluentImpl that = (BrokerSpecFluentImpl) o;
            if (channelTemplateSpec != null ? !channelTemplateSpec.equals(that.channelTemplateSpec) :that.channelTemplateSpec != null) return false;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
            return true;
    }


    public class ChannelTemplateSpecNestedImpl<N> extends ChannelTemplateSpecFluentImpl<BrokerSpecFluent.ChannelTemplateSpecNested<N>> implements BrokerSpecFluent.ChannelTemplateSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelTemplateSpecBuilder builder;
    
            ChannelTemplateSpecNestedImpl(ChannelTemplateSpec item){
                    this.builder = new ChannelTemplateSpecBuilder(this, item);
            }
            ChannelTemplateSpecNestedImpl(){
                    this.builder = new ChannelTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) BrokerSpecFluentImpl.this.withChannelTemplateSpec(builder.build());
    }
    public N endChannelTemplateSpec(){
            return and();
    }

}
    public class ConfigNestedImpl<N> extends KReferenceFluentImpl<BrokerSpecFluent.ConfigNested<N>> implements BrokerSpecFluent.ConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KReferenceBuilder builder;
    
            ConfigNestedImpl(KReference item){
                    this.builder = new KReferenceBuilder(this, item);
            }
            ConfigNestedImpl(){
                    this.builder = new KReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BrokerSpecFluentImpl.this.withConfig(builder.build());
    }
    public N endConfig(){
            return and();
    }

}
    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<BrokerSpecFluent.DeliveryNested<N>> implements BrokerSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeliverySpecBuilder builder;
    
            DeliveryNestedImpl(DeliverySpec item){
                    this.builder = new DeliverySpecBuilder(this, item);
            }
            DeliveryNestedImpl(){
                    this.builder = new DeliverySpecBuilder(this);
            }
    
    public N and(){
            return (N) BrokerSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery(){
            return and();
    }

}


}
