package io.fabric8.knative.internal.serving.pkg.apis.serving.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface RevisionSpecFluent<A extends RevisionSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean hasActiveDeadlineSeconds();
    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public Boolean isAutomountServiceAccountToken();
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
    public Boolean hasAutomountServiceAccountToken();
    public A withNewAutomountServiceAccountToken(String arg1);
    public A withNewAutomountServiceAccountToken(boolean arg1);
    public Long getContainerConcurrency();
    public A withContainerConcurrency(Long containerConcurrency);
    public Boolean hasContainerConcurrency();
    public A addToContainers(int index,Container item);
    public A setToContainers(int index,Container item);
    public A addToContainers(Container... items);
    public A addAllToContainers(Collection<Container> items);
    public A removeFromContainers(Container... items);
    public A removeAllFromContainers(Collection<Container> items);
    public List<Container> getContainers();
    public Container getContainer(int index);
    public Container getFirstContainer();
    public Container getLastContainer();
    public Container getMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate);
    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate);
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public Boolean hasContainers();
    public PodDNSConfig getDnsConfig();
    public A withDnsConfig(PodDNSConfig dnsConfig);
    public Boolean hasDnsConfig();
    public String getDnsPolicy();
    public A withDnsPolicy(String dnsPolicy);
    public Boolean hasDnsPolicy();
    public A withNewDnsPolicy(String arg1);
    public A withNewDnsPolicy(StringBuilder arg1);
    public A withNewDnsPolicy(StringBuffer arg1);
    public Boolean isEnableServiceLinks();
    public A withEnableServiceLinks(Boolean enableServiceLinks);
    public Boolean hasEnableServiceLinks();
    public A withNewEnableServiceLinks(String arg1);
    public A withNewEnableServiceLinks(boolean arg1);
    public A addToEphemeralContainers(int index,EphemeralContainer item);
    public A setToEphemeralContainers(int index,EphemeralContainer item);
    public A addToEphemeralContainers(EphemeralContainer... items);
    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items);
    public A removeFromEphemeralContainers(EphemeralContainer... items);
    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items);
    public List<EphemeralContainer> getEphemeralContainers();
    public EphemeralContainer getEphemeralContainer(int index);
    public EphemeralContainer getFirstEphemeralContainer();
    public EphemeralContainer getLastEphemeralContainer();
    public EphemeralContainer getMatchingEphemeralContainer(io.fabric8.kubernetes.api.builder.Predicate<EphemeralContainer> predicate);
    public Boolean hasMatchingEphemeralContainer(io.fabric8.kubernetes.api.builder.Predicate<EphemeralContainer> predicate);
    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers);
    public A withEphemeralContainers(EphemeralContainer... ephemeralContainers);
    public Boolean hasEphemeralContainers();
    public A addToHostAliases(int index,HostAlias item);
    public A setToHostAliases(int index,HostAlias item);
    public A addToHostAliases(HostAlias... items);
    public A addAllToHostAliases(Collection<HostAlias> items);
    public A removeFromHostAliases(HostAlias... items);
    public A removeAllFromHostAliases(Collection<HostAlias> items);
    public List<HostAlias> getHostAliases();
    public HostAlias getHostAlias(int index);
    public HostAlias getFirstHostAlias();
    public HostAlias getLastHostAlias();
    public HostAlias getMatchingHostAlias(io.fabric8.kubernetes.api.builder.Predicate<HostAlias> predicate);
    public Boolean hasMatchingHostAlias(io.fabric8.kubernetes.api.builder.Predicate<HostAlias> predicate);
    public A withHostAliases(List<HostAlias> hostAliases);
    public A withHostAliases(HostAlias... hostAliases);
    public Boolean hasHostAliases();
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public A withNewHostIPC(String arg1);
    public A withNewHostIPC(boolean arg1);
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public A withNewHostNetwork(String arg1);
    public A withNewHostNetwork(boolean arg1);
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public A withNewHostPID(String arg1);
    public A withNewHostPID(boolean arg1);
    public String getHostname();
    public A withHostname(String hostname);
    public Boolean hasHostname();
    public A withNewHostname(String arg1);
    public A withNewHostname(StringBuilder arg1);
    public A withNewHostname(StringBuffer arg1);
    public A addToImagePullSecrets(int index,LocalObjectReference item);
    public A setToImagePullSecrets(int index,LocalObjectReference item);
    public A addToImagePullSecrets(LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
    public A removeFromImagePullSecrets(LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
    public List<LocalObjectReference> getImagePullSecrets();
    public LocalObjectReference getImagePullSecret(int index);
    public LocalObjectReference getFirstImagePullSecret();
    public LocalObjectReference getLastImagePullSecret();
    public LocalObjectReference getMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReference> predicate);
    public Boolean hasMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReference> predicate);
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public A addNewImagePullSecret(String name);
    public A addToInitContainers(int index,Container item);
    public A setToInitContainers(int index,Container item);
    public A addToInitContainers(Container... items);
    public A addAllToInitContainers(Collection<Container> items);
    public A removeFromInitContainers(Container... items);
    public A removeAllFromInitContainers(Collection<Container> items);
    public List<Container> getInitContainers();
    public Container getInitContainer(int index);
    public Container getFirstInitContainer();
    public Container getLastInitContainer();
    public Container getMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate);
    public Boolean hasMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate);
    public A withInitContainers(List<Container> initContainers);
    public A withInitContainers(Container... initContainers);
    public Boolean hasInitContainers();
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A withNewNodeName(String arg1);
    public A withNewNodeName(StringBuilder arg1);
    public A withNewNodeName(StringBuffer arg1);
    public A addToNodeSelector(String key,String value);
    public A addToNodeSelector(Map<String,String> map);
    public A removeFromNodeSelector(String key);
    public A removeFromNodeSelector(Map<String,String> map);
    public Map<String,String> getNodeSelector();
    public A withNodeSelector(Map<String,String> nodeSelector);
    public Boolean hasNodeSelector();
    public A addToOverhead(String key,Quantity value);
    public A addToOverhead(Map<String,Quantity> map);
    public A removeFromOverhead(String key);
    public A removeFromOverhead(Map<String,Quantity> map);
    public Map<String,Quantity> getOverhead();
    public A withOverhead(Map<String,Quantity> overhead);
    public Boolean hasOverhead();
    public String getPreemptionPolicy();
    public A withPreemptionPolicy(String preemptionPolicy);
    public Boolean hasPreemptionPolicy();
    public A withNewPreemptionPolicy(String arg1);
    public A withNewPreemptionPolicy(StringBuilder arg1);
    public A withNewPreemptionPolicy(StringBuffer arg1);
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean hasPriority();
    public String getPriorityClassName();
    public A withPriorityClassName(String priorityClassName);
    public Boolean hasPriorityClassName();
    public A withNewPriorityClassName(String arg1);
    public A withNewPriorityClassName(StringBuilder arg1);
    public A withNewPriorityClassName(StringBuffer arg1);
    public A addToReadinessGates(int index,PodReadinessGate item);
    public A setToReadinessGates(int index,PodReadinessGate item);
    public A addToReadinessGates(PodReadinessGate... items);
    public A addAllToReadinessGates(Collection<PodReadinessGate> items);
    public A removeFromReadinessGates(PodReadinessGate... items);
    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items);
    public List<PodReadinessGate> getReadinessGates();
    public PodReadinessGate getReadinessGate(int index);
    public PodReadinessGate getFirstReadinessGate();
    public PodReadinessGate getLastReadinessGate();
    public PodReadinessGate getMatchingReadinessGate(io.fabric8.kubernetes.api.builder.Predicate<PodReadinessGate> predicate);
    public Boolean hasMatchingReadinessGate(io.fabric8.kubernetes.api.builder.Predicate<PodReadinessGate> predicate);
    public A withReadinessGates(List<PodReadinessGate> readinessGates);
    public A withReadinessGates(PodReadinessGate... readinessGates);
    public Boolean hasReadinessGates();
    public A addNewReadinessGate(String conditionType);
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public Boolean hasRestartPolicy();
    public A withNewRestartPolicy(String arg1);
    public A withNewRestartPolicy(StringBuilder arg1);
    public A withNewRestartPolicy(StringBuffer arg1);
    public String getRuntimeClassName();
    public A withRuntimeClassName(String runtimeClassName);
    public Boolean hasRuntimeClassName();
    public A withNewRuntimeClassName(String arg1);
    public A withNewRuntimeClassName(StringBuilder arg1);
    public A withNewRuntimeClassName(StringBuffer arg1);
    public String getSchedulerName();
    public A withSchedulerName(String schedulerName);
    public Boolean hasSchedulerName();
    public A withNewSchedulerName(String arg1);
    public A withNewSchedulerName(StringBuilder arg1);
    public A withNewSchedulerName(StringBuffer arg1);
    public PodSecurityContext getSecurityContext();
    public A withSecurityContext(PodSecurityContext securityContext);
    public Boolean hasSecurityContext();
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(String arg1);
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public Boolean isShareProcessNamespace();
    public A withShareProcessNamespace(Boolean shareProcessNamespace);
    public Boolean hasShareProcessNamespace();
    public A withNewShareProcessNamespace(String arg1);
    public A withNewShareProcessNamespace(boolean arg1);
    public String getSubdomain();
    public A withSubdomain(String subdomain);
    public Boolean hasSubdomain();
    public A withNewSubdomain(String arg1);
    public A withNewSubdomain(StringBuilder arg1);
    public A withNewSubdomain(StringBuffer arg1);
    public Long getTerminationGracePeriodSeconds();
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
    public Boolean hasTerminationGracePeriodSeconds();
    public Long getTimeoutSeconds();
    public A withTimeoutSeconds(Long timeoutSeconds);
    public Boolean hasTimeoutSeconds();
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
    public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
    public A addToTopologySpreadConstraints(TopologySpreadConstraint... items);
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint... items);
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
    public List<TopologySpreadConstraint> getTopologySpreadConstraints();
    public TopologySpreadConstraint getTopologySpreadConstraint(int index);
    public TopologySpreadConstraint getFirstTopologySpreadConstraint();
    public TopologySpreadConstraint getLastTopologySpreadConstraint();
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(io.fabric8.kubernetes.api.builder.Predicate<TopologySpreadConstraint> predicate);
    public Boolean hasMatchingTopologySpreadConstraint(io.fabric8.kubernetes.api.builder.Predicate<TopologySpreadConstraint> predicate);
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
    public A withTopologySpreadConstraints(TopologySpreadConstraint... topologySpreadConstraints);
    public Boolean hasTopologySpreadConstraints();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    public List<Volume> getVolumes();
    public Volume getVolume(int index);
    public Volume getFirstVolume();
    public Volume getLastVolume();
    public Volume getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate);
    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();



}
