package io.fabric8.knative.internal.serving.pkg.apis.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TrafficTargetBuilder extends TrafficTargetFluentImpl<TrafficTargetBuilder> implements VisitableBuilder<TrafficTarget,TrafficTargetBuilder>{

    TrafficTargetFluent<?> fluent;
    Boolean validationEnabled;

    public TrafficTargetBuilder(){
            this(true);
    }
    public TrafficTargetBuilder(Boolean validationEnabled){
            this(new TrafficTarget(), validationEnabled);
    }
    public TrafficTargetBuilder(TrafficTargetFluent<?> fluent){
            this(fluent, true);
    }
    public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TrafficTarget(), validationEnabled);
    }
    public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,TrafficTarget instance){
            this(fluent, instance, true);
    }
    public TrafficTargetBuilder(TrafficTargetFluent<?> fluent,TrafficTarget instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfigurationName(instance.getConfigurationName()); 
            fluent.withLatestRevision(instance.getLatestRevision()); 
            fluent.withPercent(instance.getPercent()); 
            fluent.withRevisionName(instance.getRevisionName()); 
            fluent.withTag(instance.getTag()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public TrafficTargetBuilder(TrafficTarget instance){
            this(instance,true);
    }
    public TrafficTargetBuilder(TrafficTarget instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfigurationName(instance.getConfigurationName()); 
            this.withLatestRevision(instance.getLatestRevision()); 
            this.withPercent(instance.getPercent()); 
            this.withRevisionName(instance.getRevisionName()); 
            this.withTag(instance.getTag()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public TrafficTarget build(){
            TrafficTarget buildable = new TrafficTarget(fluent.getConfigurationName(),fluent.isLatestRevision(),fluent.getPercent(),fluent.getRevisionName(),fluent.getTag(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TrafficTargetBuilder that = (TrafficTargetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
