package io.fabric8.knative.messaging.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.Subscribable;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1.ChannelTemplateSpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.SubscribableBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpecBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.messaging.v1beta1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1alpha1.SubscribableFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1beta1.DeliverySpec;

public class ChannelSpecFluentImpl<A extends ChannelSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelSpecFluent<A>{

    private ChannelTemplateSpecBuilder channelTemplate;
    private DeliverySpecBuilder delivery;
    private SubscribableBuilder subscribable;

    public ChannelSpecFluentImpl(){
    }
    public ChannelSpecFluentImpl(ChannelSpec instance){
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withDelivery(instance.getDelivery()); 
            this.withSubscribable(instance.getSubscribable()); 
    }

    
/**
 * This method has been deprecated, please use method buildChannelTemplate instead.
 * @return The buildable object.
 */
@Deprecated public ChannelTemplateSpec getChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public ChannelTemplateSpec buildChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(ChannelTemplateSpec channelTemplate){
            _visitables.get("channelTemplate").remove(this.channelTemplate);
            if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public Boolean hasChannelTemplate(){
            return this.channelTemplate != null;
    }

    public ChannelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate(){
            return new ChannelTemplateNestedImpl();
    }

    public ChannelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item){
            return new ChannelTemplateNestedImpl(item);
    }

    public ChannelSpecFluent.ChannelTemplateNested<A> editChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate());
    }

    public ChannelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new ChannelTemplateSpecBuilder().build());
    }

    public ChannelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery){
            _visitables.get("delivery").remove(this.delivery);
            if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery(){
            return this.delivery != null;
    }

    public ChannelSpecFluent.DeliveryNested<A> withNewDelivery(){
            return new DeliveryNestedImpl();
    }

    public ChannelSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item){
            return new DeliveryNestedImpl(item);
    }

    public ChannelSpecFluent.DeliveryNested<A> editDelivery(){
            return withNewDeliveryLike(getDelivery());
    }

    public ChannelSpecFluent.DeliveryNested<A> editOrNewDelivery(){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public ChannelSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscribable instead.
 * @return The buildable object.
 */
@Deprecated public Subscribable getSubscribable(){
            return this.subscribable!=null?this.subscribable.build():null;
    }

    public Subscribable buildSubscribable(){
            return this.subscribable!=null?this.subscribable.build():null;
    }

    public A withSubscribable(Subscribable subscribable){
            _visitables.get("subscribable").remove(this.subscribable);
            if (subscribable!=null){ this.subscribable= new SubscribableBuilder(subscribable); _visitables.get("subscribable").add(this.subscribable);} return (A) this;
    }

    public Boolean hasSubscribable(){
            return this.subscribable != null;
    }

    public ChannelSpecFluent.SubscribableNested<A> withNewSubscribable(){
            return new SubscribableNestedImpl();
    }

    public ChannelSpecFluent.SubscribableNested<A> withNewSubscribableLike(Subscribable item){
            return new SubscribableNestedImpl(item);
    }

    public ChannelSpecFluent.SubscribableNested<A> editSubscribable(){
            return withNewSubscribableLike(getSubscribable());
    }

    public ChannelSpecFluent.SubscribableNested<A> editOrNewSubscribable(){
            return withNewSubscribableLike(getSubscribable() != null ? getSubscribable(): new SubscribableBuilder().build());
    }

    public ChannelSpecFluent.SubscribableNested<A> editOrNewSubscribableLike(Subscribable item){
            return withNewSubscribableLike(getSubscribable() != null ? getSubscribable(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelSpecFluentImpl that = (ChannelSpecFluentImpl) o;
            if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
            if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
            if (subscribable != null ? !subscribable.equals(that.subscribable) :that.subscribable != null) return false;
            return true;
    }


    public class ChannelTemplateNestedImpl<N> extends ChannelTemplateSpecFluentImpl<ChannelSpecFluent.ChannelTemplateNested<N>> implements ChannelSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelTemplateSpecBuilder builder;
    
            ChannelTemplateNestedImpl(ChannelTemplateSpec item){
                    this.builder = new ChannelTemplateSpecBuilder(this, item);
            }
            ChannelTemplateNestedImpl(){
                    this.builder = new ChannelTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ChannelSpecFluentImpl.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate(){
            return and();
    }

}
    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<ChannelSpecFluent.DeliveryNested<N>> implements ChannelSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeliverySpecBuilder builder;
    
            DeliveryNestedImpl(DeliverySpec item){
                    this.builder = new DeliverySpecBuilder(this, item);
            }
            DeliveryNestedImpl(){
                    this.builder = new DeliverySpecBuilder(this);
            }
    
    public N and(){
            return (N) ChannelSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery(){
            return and();
    }

}
    public class SubscribableNestedImpl<N> extends SubscribableFluentImpl<ChannelSpecFluent.SubscribableNested<N>> implements ChannelSpecFluent.SubscribableNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscribableBuilder builder;
    
            SubscribableNestedImpl(Subscribable item){
                    this.builder = new SubscribableBuilder(this, item);
            }
            SubscribableNestedImpl(){
                    this.builder = new SubscribableBuilder(this);
            }
    
    public N and(){
            return (N) ChannelSpecFluentImpl.this.withSubscribable(builder.build());
    }
    public N endSubscribable(){
            return and();
    }

}


}
