package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteStatusBuilder extends io.fabric8.knative.serving.v1.RouteStatusFluentImpl<io.fabric8.knative.serving.v1.RouteStatusBuilder> implements VisitableBuilder<io.fabric8.knative.serving.v1.RouteStatus,io.fabric8.knative.serving.v1.RouteStatusBuilder>{

    io.fabric8.knative.serving.v1.RouteStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RouteStatusBuilder(){
            this(true);
    }
    public RouteStatusBuilder(Boolean validationEnabled){
            this(new RouteStatus(), validationEnabled);
    }
    public RouteStatusBuilder(io.fabric8.knative.serving.v1.RouteStatusFluent<?> fluent){
            this(fluent, true);
    }
    public RouteStatusBuilder(io.fabric8.knative.serving.v1.RouteStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteStatus(), validationEnabled);
    }
    public RouteStatusBuilder(io.fabric8.knative.serving.v1.RouteStatusFluent<?> fluent,io.fabric8.knative.serving.v1.RouteStatus instance){
            this(fluent, instance, true);
    }
    public RouteStatusBuilder(io.fabric8.knative.serving.v1.RouteStatusFluent<?> fluent,io.fabric8.knative.serving.v1.RouteStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withTraffic(instance.getTraffic()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteStatusBuilder(io.fabric8.knative.serving.v1.RouteStatus instance){
            this(instance,true);
    }
    public RouteStatusBuilder(io.fabric8.knative.serving.v1.RouteStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withTraffic(instance.getTraffic()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1.RouteStatus build(){
            RouteStatus buildable = new RouteStatus(fluent.getAddress(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getTraffic(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteStatusBuilder that = (RouteStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
