/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.RevisionSpec;
import io.fabric8.knative.serving.v1.RevisionSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>>
extends BaseFluent<A>
implements RevisionSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private Affinity affinity;
    private Boolean automountServiceAccountToken;
    private Long containerConcurrency;
    private List<Container> containers;
    private PodDNSConfig dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<EphemeralContainer> ephemeralContainers;
    private List<HostAlias> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<LocalObjectReference> imagePullSecrets;
    private List<Container> initContainers;
    private String nodeName;
    private Map<String, String> nodeSelector;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private List<PodReadinessGate> readinessGates;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContext securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private Long timeoutSeconds;
    private List<Toleration> tolerations;
    private List<TopologySpreadConstraint> topologySpreadConstraints;
    private List<Volume> volumes;

    public RevisionSpecFluentImpl() {
    }

    public RevisionSpecFluentImpl(RevisionSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAffinity(instance.getAffinity());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withContainerConcurrency(instance.getContainerConcurrency());
        this.withContainers(instance.getContainers());
        this.withDnsConfig(instance.getDnsConfig());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.withEphemeralContainers(instance.getEphemeralContainers());
        this.withHostAliases(instance.getHostAliases());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOverhead(instance.getOverhead());
        this.withPreemptionPolicy(instance.getPreemptionPolicy());
        this.withPriority(instance.getPriority());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withReadinessGates(instance.getReadinessGates());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withRuntimeClassName(instance.getRuntimeClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withShareProcessNamespace(instance.getShareProcessNamespace());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withTolerations(instance.getTolerations());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public Boolean isAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public A withNewAutomountServiceAccountToken(String arg1) {
        return this.withAutomountServiceAccountToken(new Boolean(arg1));
    }

    @Override
    public A withNewAutomountServiceAccountToken(boolean arg1) {
        return this.withAutomountServiceAccountToken(new Boolean(arg1));
    }

    @Override
    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    @Override
    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)this;
    }

    @Override
    public Boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    @Override
    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        this.containers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        this.containers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.containers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.containers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            if (this.containers == null) continue;
            this.containers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            if (this.containers == null) continue;
            this.containers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Container> getContainers() {
        return this.containers;
    }

    @Override
    public Container getContainer(int index) {
        return this.containers.get(index);
    }

    @Override
    public Container getFirstContainer() {
        return this.containers.get(0);
    }

    @Override
    public Container getLastContainer() {
        return this.containers.get(this.containers.size() - 1);
    }

    @Override
    public Container getMatchingContainer(Predicate<Container> predicate) {
        for (Container item : this.containers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<Container> predicate) {
        for (Container item : this.containers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<Container>();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    @Override
    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return (A)this;
    }

    @Override
    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    public A withNewDnsPolicy(String arg1) {
        return this.withDnsPolicy(new String(arg1));
    }

    @Override
    public A withNewDnsPolicy(StringBuilder arg1) {
        return this.withDnsPolicy(new String(arg1));
    }

    @Override
    public A withNewDnsPolicy(StringBuffer arg1) {
        return this.withDnsPolicy(new String(arg1));
    }

    @Override
    public Boolean isEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    @Override
    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    @Override
    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    @Override
    public A withNewEnableServiceLinks(String arg1) {
        return this.withEnableServiceLinks(new Boolean(arg1));
    }

    @Override
    public A withNewEnableServiceLinks(boolean arg1) {
        return this.withEnableServiceLinks(new Boolean(arg1));
    }

    @Override
    public A addToEphemeralContainers(int index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainers(int index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainers(EphemeralContainer ... items) {
        for (EphemeralContainer item : items) {
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        for (EphemeralContainer item : items) {
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers;
    }

    @Override
    public EphemeralContainer getEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index);
    }

    @Override
    public EphemeralContainer getFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0);
    }

    @Override
    public EphemeralContainer getLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1);
    }

    @Override
    public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this._visitables.get((Object)"ephemeralContainers").removeAll(this.ephemeralContainers);
        }
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainers(EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    @Override
    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    @Override
    public HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    @Override
    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    @Override
    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1);
    }

    @Override
    public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get((Object)"hostAliases").removeAll(this.hostAliases);
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAlias>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public A withNewHostIPC(String arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public A withNewHostIPC(boolean arg1) {
        return this.withHostIPC(new Boolean(arg1));
    }

    @Override
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public A withNewHostNetwork(String arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public A withNewHostNetwork(boolean arg1) {
        return this.withHostNetwork(new Boolean(arg1));
    }

    @Override
    public Boolean isHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public A withNewHostPID(String arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public A withNewHostPID(boolean arg1) {
        return this.withHostPID(new Boolean(arg1));
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A withNewHostname(String arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuilder arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuffer arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.imagePullSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.imagePullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @Override
    public LocalObjectReference getImagePullSecret(int index) {
        return this.imagePullSecrets.get(index);
    }

    @Override
    public LocalObjectReference getFirstImagePullSecret() {
        return this.imagePullSecrets.get(0);
    }

    @Override
    public LocalObjectReference getLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1);
    }

    @Override
    public LocalObjectReference getMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.imagePullSecrets) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.imagePullSecrets) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get((Object)"imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReference>();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<Container>();
        }
        this.initContainers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<Container>();
        }
        this.initContainers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.initContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.initContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            if (this.initContainers == null) continue;
            this.initContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            if (this.initContainers == null) continue;
            this.initContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Container> getInitContainers() {
        return this.initContainers;
    }

    @Override
    public Container getInitContainer(int index) {
        return this.initContainers.get(index);
    }

    @Override
    public Container getFirstInitContainer() {
        return this.initContainers.get(0);
    }

    @Override
    public Container getLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1);
    }

    @Override
    public Container getMatchingInitContainer(Predicate<Container> predicate) {
        for (Container item : this.initContainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<Container> predicate) {
        for (Container item : this.initContainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList<Container>();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public A withNewNodeName(String arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuilder arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A withNewNodeName(StringBuffer arg1) {
        return this.withNodeName(new String(arg1));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    @Override
    public A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)this;
    }

    @Override
    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    @Override
    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    @Override
    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    @Override
    public A withNewPreemptionPolicy(String arg1) {
        return this.withPreemptionPolicy(new String(arg1));
    }

    @Override
    public A withNewPreemptionPolicy(StringBuilder arg1) {
        return this.withPreemptionPolicy(new String(arg1));
    }

    @Override
    public A withNewPreemptionPolicy(StringBuffer arg1) {
        return this.withPreemptionPolicy(new String(arg1));
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public A withNewPriorityClassName(String arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuilder arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A withNewPriorityClassName(StringBuffer arg1) {
        return this.withPriorityClassName(new String(arg1));
    }

    @Override
    public A addToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        this.readinessGates.add(index, item);
        return (A)this;
    }

    @Override
    public A setToReadinessGates(int index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        this.readinessGates.set(index, item);
        return (A)this;
    }

    @Override
    public A addToReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
        }
        for (PodReadinessGate item : items) {
            this.readinessGates.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessGates(PodReadinessGate ... items) {
        for (PodReadinessGate item : items) {
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        for (PodReadinessGate item : items) {
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<PodReadinessGate> getReadinessGates() {
        return this.readinessGates;
    }

    @Override
    public PodReadinessGate getReadinessGate(int index) {
        return this.readinessGates.get(index);
    }

    @Override
    public PodReadinessGate getFirstReadinessGate() {
        return this.readinessGates.get(0);
    }

    @Override
    public PodReadinessGate getLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1);
    }

    @Override
    public PodReadinessGate getMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item : this.readinessGates) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item : this.readinessGates) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get((Object)"readinessGates").removeAll(this.readinessGates);
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList<PodReadinessGate>();
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)this;
    }

    @Override
    public A withReadinessGates(PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
        }
        if (readinessGates != null) {
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    @Override
    public A addNewReadinessGate(String conditionType) {
        return this.addToReadinessGates(new PodReadinessGate(conditionType));
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    public A withNewRestartPolicy(String arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public A withNewRestartPolicy(StringBuilder arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public A withNewRestartPolicy(StringBuffer arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    @Override
    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    @Override
    public A withNewRuntimeClassName(String arg1) {
        return this.withRuntimeClassName(new String(arg1));
    }

    @Override
    public A withNewRuntimeClassName(StringBuilder arg1) {
        return this.withRuntimeClassName(new String(arg1));
    }

    @Override
    public A withNewRuntimeClassName(StringBuffer arg1) {
        return this.withRuntimeClassName(new String(arg1));
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    public A withNewSchedulerName(String arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A withNewSchedulerName(StringBuilder arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public A withNewSchedulerName(StringBuffer arg1) {
        return this.withSchedulerName(new String(arg1));
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public A withNewServiceAccount(String arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuilder arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuffer arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public A withNewServiceAccountName(String arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuilder arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuffer arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public Boolean isShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    @Override
    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    @Override
    public A withNewShareProcessNamespace(String arg1) {
        return this.withShareProcessNamespace(new Boolean(arg1));
    }

    @Override
    public A withNewShareProcessNamespace(boolean arg1) {
        return this.withShareProcessNamespace(new Boolean(arg1));
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    @Override
    public A withNewSubdomain(String arg1) {
        return this.withSubdomain(new String(arg1));
    }

    @Override
    public A withNewSubdomain(StringBuilder arg1) {
        return this.withSubdomain(new String(arg1));
    }

    @Override
    public A withNewSubdomain(StringBuffer arg1) {
        return this.withSubdomain(new String(arg1));
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    @Override
    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get((Object)"tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    @Override
    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    @Override
    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    @Override
    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    @Override
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get((Object)"topologySpreadConstraints").removeAll(this.topologySpreadConstraints);
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionSpecFluentImpl that = (RevisionSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals((Object)that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) {
            return false;
        }
        if (this.containerConcurrency != null ? !this.containerConcurrency.equals(that.containerConcurrency) : that.containerConcurrency != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsConfig != null ? !this.dnsConfig.equals((Object)that.dnsConfig) : that.dnsConfig != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.enableServiceLinks != null ? !this.enableServiceLinks.equals(that.enableServiceLinks) : that.enableServiceLinks != null) {
            return false;
        }
        if (this.ephemeralContainers != null ? !this.ephemeralContainers.equals(that.ephemeralContainers) : that.ephemeralContainers != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.overhead != null ? !this.overhead.equals(that.overhead) : that.overhead != null) {
            return false;
        }
        if (this.preemptionPolicy != null ? !this.preemptionPolicy.equals(that.preemptionPolicy) : that.preemptionPolicy != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.readinessGates != null ? !this.readinessGates.equals(that.readinessGates) : that.readinessGates != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.runtimeClassName != null ? !this.runtimeClassName.equals(that.runtimeClassName) : that.runtimeClassName != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals((Object)that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.shareProcessNamespace != null ? !this.shareProcessNamespace.equals(that.shareProcessNamespace) : that.shareProcessNamespace != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.topologySpreadConstraints != null ? !this.topologySpreadConstraints.equals(that.topologySpreadConstraints) : that.topologySpreadConstraints != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }
}

