package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CouchDbSourceSpecBuilder extends CouchDbSourceSpecFluentImpl<CouchDbSourceSpecBuilder> implements VisitableBuilder<CouchDbSourceSpec,CouchDbSourceSpecBuilder> {

    CouchDbSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CouchDbSourceSpecBuilder() { 
        this(true);
    }


    public CouchDbSourceSpecBuilder(Boolean validationEnabled) { 
        this(new CouchDbSourceSpec(), validationEnabled);
    }


    public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CouchDbSourceSpec(), validationEnabled);
    }


    public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent,CouchDbSourceSpec instance) { 
        this(fluent, instance, true);
    }


    public CouchDbSourceSpecBuilder(CouchDbSourceSpecFluent<?> fluent,CouchDbSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCredentials(instance.getCredentials()); 
        fluent.withDatabase(instance.getDatabase()); 
        fluent.withFeed(instance.getFeed()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSink(instance.getSink()); 
        this.validationEnabled = validationEnabled; 
    }


    public CouchDbSourceSpecBuilder(CouchDbSourceSpec instance) { 
        this(instance,true);
    }


    public CouchDbSourceSpecBuilder(CouchDbSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCredentials(instance.getCredentials()); 
        this.withDatabase(instance.getDatabase()); 
        this.withFeed(instance.getFeed()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
        this.validationEnabled = validationEnabled; 
    }


    public CouchDbSourceSpec build() {
        CouchDbSourceSpec buildable = new CouchDbSourceSpec(fluent.getCredentials(),fluent.getDatabase(),fluent.getFeed(),fluent.getServiceAccountName(),fluent.getSink());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CouchDbSourceSpecBuilder that = (CouchDbSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
