package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBindingStatusBuilder extends KafkaBindingStatusFluentImpl<KafkaBindingStatusBuilder> implements VisitableBuilder<KafkaBindingStatus,KafkaBindingStatusBuilder> {

    KafkaBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBindingStatusBuilder() { 
        this(true);
    }


    public KafkaBindingStatusBuilder(Boolean validationEnabled) { 
        this(new KafkaBindingStatus(), validationEnabled);
    }


    public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KafkaBindingStatus(), validationEnabled);
    }


    public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent,KafkaBindingStatus instance) { 
        this(fluent, instance, true);
    }


    public KafkaBindingStatusBuilder(KafkaBindingStatusFluent<?> fluent,KafkaBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaBindingStatusBuilder(KafkaBindingStatus instance) { 
        this(instance,true);
    }


    public KafkaBindingStatusBuilder(KafkaBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaBindingStatus build() {
        KafkaBindingStatus buildable = new KafkaBindingStatus(fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBindingStatusBuilder that = (KafkaBindingStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
